/***************************************************************************
                          ann_ds_xpm.cpp  -  description
                             -------------------
    begin                : nie maj 4 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "config.h"

#if STDC_HEADERS
# include <stdlib.h>
# include <stddef.h>
#else
# if HAVE_STDLIB_H
#  include <stdlib.h>
# endif
#endif
#if HAVE_STRING_H
# if !STDC_HEADERS && HAVE_MEMORY_H
#  include <memory.h>
# endif
# include <string.h>
#endif
#if HAVE_STRINGS_H
# include <strings.h>
#endif
#if HAVE_LIMITS_H
#include <limits.h>
#endif

#include <ann_ds_xpm.h>

  //                   //
 // class ANN::DS_xpm //
//                   //

#include <ann_loc_io.h>

void
ANN::DS_xpm::import(std::istream &is, double black, double white)
{
  struct ColDef
  {
    char *tag;
    int   val;
  };

  char   buff[3];
  size_t pic_size[2], colors, chars, i, j;
# define width  pic_size[1]
# define height pic_size[0]
  int    val;
  is.ignore(INT_MAX,'\"');
  is >> width >> height >> colors >> chars;
  ColDef *coldefs=new ColDef[colors];
  if (is)
  {
    char   *tags=new char[colors*(chars+1)];
    char   *btag=new char[chars+1];
    char   *ptag;
    for (i=0, ptag=tags; i<colors; ++i, ptag+=chars+1)
    {
      is.ignore(INT_MAX,'\"');
      is.ignore(INT_MAX,'\"');
      is.read(ptag,chars);
      ptag[chars]=0;
      coldefs[i].tag=ptag;
      is.ignore(INT_MAX,'#');
      val=0;
      j=0;
      while (is.get(buff,3,'\"'))
      {
        if (!*buff) break;
        ++j;
        val+=strtol(buff,0,16);
      }
      is.clear();
      if (j) val/=j;
      coldefs[i].val=val;
    }
    if (is)
    {
      set_limits(1,Size(2,pic_size));
      double *data_=all_terms()->get_data();
      double  delta=white-black;
      for (size_t h=0; h<height; ++h)
      {
        is.ignore(INT_MAX,'\"');
        is.ignore(INT_MAX,'\"');
        for(size_t w=0; w<width; ++w, ++data_)
        {
          *data_=black;
          if (is.get(btag,chars+1,'\"')) if (*btag) for(j=0; j<colors; ++j)
          if (!strcmp(btag,coldefs[j].tag))
          {
            *data_+=coldefs[j].val*delta/255;
            break;
          }
        }
      }
    }
    delete [] coldefs;
    delete [] tags;
    delete [] btag;
  }
}
