/***************************************************************************
                          ann_w_static.h  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_W_STATIC_H
#define __ANN_W_STATIC_H

#include <ann_weight.h>
#include <ann_wg_set.h>
#include <ann_wc.h>
#include <ann_w_member.h>

namespace ANN
{

  class W_static;

  //                 //
 // class WG_static //
//                 //

  typedef WG_set<W_static,W::Instance_t> WG_static;
  typedef FB<WG_static>                  WG_static_FB;
  typedef F<WG_static>                   WG_static_F;

  //                //
 // class W_static //
//                //

  class W_static : public W
  {
  private:
    W_static();
    W_static(const W_static &);

  public:
    typedef WC<WG_static>  Common_t;
    typedef W::Instance_t  Instance_t;
    typedef W              Base_t;
    typedef WG_static      WG_t;

    W_static(Common_t &c, Instance_t inst) : W(inst) {}
    virtual ~W_static();

    virtual void       feed_back(const Term &d_);
    virtual void       commit(NE &ne);
    virtual void       randomize();             
    virtual WG_static &the_group() const=0;
  };

  typedef WC<WG_static>          WC_static;
  typedef F<W_member<W_static> > W_static_F;

} // namespace ANN

#endif /* __ANN_W_STATIC_H */
