/***************************************************************************
                          ann_w_member.h  -  description
                             -------------------
    begin                : wto kwi 22 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_W_MEMBER_H
#define __ANN_W_MEMBER_H

#include <ann_weight.h>
#include <ann_wc.h>

namespace ANN
{

  template <class Weight, class Group=typename Weight::WG_t,
            class Common=WC<Group,typename Weight::Instance_t>,
            class Instance=typename Weight::Instance_t>
  class W_member;

  //template <class Weight, class Group, class Common, class Instance>//
 // class W_member                                                   //
//                                                                  //

  template <class Weight, class Group, class Common, class Instance>
  class W_member : public Weight
  {
  public:
    typedef typename Weight::Base_t Base_t;
    typedef Weight                  Item_t;
    typedef Common                  Common_t;
    typedef Instance                Instance_t;
    typedef Group                   WG_t;
    typedef FB<Group,Instance>      WG_FB_t;
    
  private:
    Group *group;

    void detach_group() { if (group) group->detach(*this); }
    void attach_group(Group &group_, Instance inst)
    { group_.attach(*this,inst); group=&group_; }

  public:
    W_member(Common &c, Instance inst) : Weight(c,inst)
    {
      if (c.wg && !c.wg->can_handle(inst)) c.wg=0;
      if (!c.wg) c.wg=c.wgf->create(inst);
      attach_group(*c.wg,inst);
    }
    virtual ~W_member() { detach_group(); }

    virtual WG    *get_group() const { return group; }
    virtual Group &the_group() const { return *group; }
    virtual void   set_group(Group &group_, Instance inst)
    { detach_group(); attach_group(group_,inst); }
  };

  template <class Weight, class Group, class Common>
  class W_member<Weight,Group,Common,void> : public Weight
  {
  public:
    typedef typename Weight::Base_t Base_t;
    typedef Weight                  Item_t;
    typedef Common                  Common_t;
    typedef void                    Instance_t;
    typedef Group                   WG_t;
    typedef FB<Group,void>          WG_FB_t;

  private:
    Group *group;

    void detach_group() { if (group) group->detach(*this); }
    void attach_group(Group &group_) { group_.attach(*this); group=&group_; }

  public:
    W_member(Common &c) : Weight(c)
    {
      if (c.wg && !c.wg->can_handle()) c.wg=0;
      if (!c.wg) c.wg=c.wgf->create();
      attach_group(*c.wg);
    }
    virtual ~W_member() { detach_group(); }

    virtual WG    *get_group() const { return group; }
    virtual Group &the_group() const { return *group; }
    virtual void   set_group(Group &group_)
    { detach_group(); attach_group(group_); }
  };

} // namespace ANN

#endif /* __ANN_W_MEMBER_H */
