/***************************************************************************
                          ann_use_nan.h  -  description
                             -------------------
    begin                : pi maj 17 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_USE_NAN_H
#define __ANN_USE_NAN_H

#include <math.h>

#include <ann_nav.h>

namespace ANN
{

# ifdef NAN

  class NAV<float>
  {
  protected:
    static const union NAN_conv
    {
      unsigned bits;
      float    fl_nan;
    } nan_conv;
  public:
    static float get() { return NAN; }
  };

# else /* NAN -- not defined */

  class NAV<float>
  {
  protected:
    static const union NAN_conv
    {
      unsigned bits;
      float    fl_nan;
    } nan_conv;
  public:
    static float get() { return nan_conv.fl_nan; }
  };

# define NAN NAV_get(float)

# endif /* NAN */

  class NAV<double>
  {
  public:
    static double get() { return NAN; }
  };

} // namespace ANN

#endif /* __ANN_USE_NAN_H */
