/***************************************************************************
                          ann_to_offline.h  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_TO_OFFLINE_H
#define __ANN_TO_OFFLINE_H

#include <ann_to.h>

namespace ANN
{
  class TO_offline;

  //                  //
 // class TO_offline //
//                  //

  class TO_offline : public TO
  {
  public:
    typedef TOC         Common_t;
    typedef const Init *Instance_t;
    typedef TO          Base_t;

  private:
    TO_offline();
    TO_offline(const TO_offline &that);

  public:
    TO_offline(NIT &trainee_, DS &ds_, Log &log_, const char *label_=0)
    : TO(trainee_,ds_,log_,label_ ? label_ : "offline") {}
    TO_offline(NIT &trainee_, DS &ds_, Log *log_, const char *label_=0)
    : TO(trainee_,ds_,log_,label_ ? label_ : "offline") {}
    TO_offline(NIT &trainee_, DS &ds_, const char *label_=0)
    : TO(trainee_,ds_,label_ ? label_ : "offline") {}
    TO_offline(Common_t &c, Instance_t inst) : TO(c,inst) {}

    virtual ~TO_offline();

  protected:
    virtual Status adapt_internal();
  };
  
  typedef F<TO_offline> TO_offline_F;

} //namespace ANN

#endif /* __ANN_TO_OFFLINE_H */
