/***************************************************************************
                          ann_tc_set.h  -  description
                             -------------------
    begin                : sob kwi 19 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __TC_SET_H
#define __TC_SET_H

#include <set>
#include <vector>

#include <ann_tc.h>

namespace ANN
{

  class TC_set;
  
  //              //
 // class TC_set //
//              //

  class TC_set : public TC
  {
  public:  
    struct TokenCmp
    { bool operator ()(const Token *t1, const Token *t2) const; };
    typedef std::set<Token *,TokenCmp> TokenSet;
    typedef TokenSet::iterator         TSIterator;

  protected:
    TokenSet tokens;

    virtual void do_recalc();
    virtual void do_put(Token &t);
    virtual bool do_get(Token &t);
    virtual void do_shrink(Token &t);
    virtual void do_erase(Token &t);
    virtual void do_clear();
    
  public:
    TC_set() {}
    virtual ~TC_set();
  };
    
} // namespace ANN

#endif /* __TC_SET_H */
