/***************************************************************************
                          ann_tc.h  -  description
                             -------------------
    begin                : sob kwi 19 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_TC_H
#define __ANN_TC_H

#include <ann_term.h>
#include <ann_ts.h>

namespace ANN
{
  class TC; /* term collector */

  //          //
 // class TC //
//          //

  class TC
  {
  public:
    class Pos
    {
    private:
      Loc    loc;
      size_t lev;
      Pos(const Pos &that);
    public:
      Pos() : lev(0) {}
      ~Pos() {}
      void   reset() { lev=0; }
      void   reset(const Loc &loc_) { loc=loc_; lev=loc_.dim(); }
      void   inc_level();
      bool   dec_level();
      size_t get_level() const { return lev; }
      void   next() { if (lev) ++loc[lev-1]; }
      void   get_loc(Loc &loc_) const { loc_.resize(lev,loc.get_coord()); }
    };
    
  protected:
    struct Token
    {
      size_t seq;
      Loc    where;
      Loc    loc;
      double val;
      Token(size_t seq_=0) : seq(seq_) {}
      Token(const Loc &w, size_t seq_=0) : seq(seq_), where(w) {}
      Token(const Loc &w, const Loc &l, size_t seq_=0)
      : seq(seq_), where(w), loc(l) {}
      Token(const Loc &w, const Loc &l, double v, size_t seq_=0)
      : seq(seq_), where(w), loc(l), val(v) {}
    };

    size_t       num_seq;
    Size         length;
    Size        *size;    
    bool         lim_valid;
    static Size  none;

    virtual void do_recalc()=0;
    virtual void do_put(Token &t)=0;
    virtual bool do_get(Token &t)=0;
    virtual void do_shrink(Token &t)=0;
    virtual void do_erase(Token &t)=0;
    virtual void do_clear()=0;    
    void         recalc();

  public:
    TC() : num_seq(0), size(0), lim_valid(true) {}
    virtual ~TC();
    
    static TC    *create();

    void          expand(Size length_) { recalc(); length.expand(length_); }
    size_t        get_seq() { recalc(); return num_seq; }
    const Size   &get_lengths() { recalc(); return length; }
    const size_t  get_length() { recalc(); return length.total_size(); }
    const Size   &get_sizes(size_t seq_)
    { recalc(); return seq_<num_seq ? size[seq_] : none; }
    const size_t  get_size(size_t seq_)
    { recalc(); return seq_<num_seq ? size[seq_].total_size() : 0; }
    void          put(const Loc &where, const Loc &loc, double val, size_t seq=0);
    double        get(const Loc &where, const Loc &loc, size_t seq=0);
    TS           *build(size_t seq);
    void          build(Term &term, const Loc &where, size_t seq);
    void          shrink(const Loc &where);
    void          erase(const Loc &where, size_t seq);
    void          erase(const Loc &where);
    void          clear();
  };
  
} // namespace ANN

#endif /* __ANN_TC_H */
