/***************************************************************************
                          ann_sink.h  -  description
                             -------------------
    begin                : nie maj 4 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_SINK_H
#define __ANN_SINK_H

#include <ann_term.h>
#include <ann_ds.h>
#include <ann_init.h>

namespace ANN
{

  class Sink;
  
  //            //
 // class Sink //
//            //

  class Sink
  {
  private:
    Sink(const Sink &that);

  protected:
    Label  label;
    size_t lab_len;
    
    Sink() : lab_len(0) {}

    void set_label(const char *label_=0)
    { label.set_label(label_ ? label_ : "pattern"); lab_len=label.length(); }
    
  public:
    virtual ~Sink();

    virtual bool open(Size lengths, Size sizes)=0;
    virtual bool feed(size_t which_, const Loc &where_, const Term &in,
                      const char *label=0)=0;
    virtual bool close()=0;

    virtual bool store(DS &data, const char *label=0);
  };  
    
} // namespace ANN

#endif /* __ANN_SINK_H */
