/***************************************************************************
                          ann_parser_ws.h  -  description
                             -------------------
    begin                : pon kwi 21 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_PARSER_WS_H
#define __ANN_PARSER_WS_H

#include <iostream>

#include <ann_tc.h>
#include <ann_ts.h>

namespace ANN
{

  //                 //
 // class Parser_ws //
//                 //

  class Parser_ws
  {
  protected:

    TC      *tc;
    TC::Pos  pos_where;
    TC::Pos  pos_loc;
    Loc      where;
    Loc      loc;
    size_t   seq;
    bool     was_val;

    virtual bool  add_str(const char *str, size_t len);
    virtual void  add_val(double x);
    virtual void  add_line();
    virtual void  next_seq();
    virtual bool  internal_parse(std::istream &is);

  public:
    Parser_ws();
    virtual ~Parser_ws();

    size_t  get_seq() const { return tc->get_seq(); }
    TS     *build(size_t seq) { return tc->build(seq); }
    bool    parse(std::istream &is);
    bool    operator() (std::istream &is) { return parse(is); }
  };
  
} // namespace ANN

#endif /* __ANN_PARSER_WS_H */
