/***************************************************************************
                          ann_nit_perc.h  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_NIT_PERC_H
#define __ANN_NIT_PERC_H

#include <ann_act.h>
#include <ann_nit_linear.h>

namespace ANN
{

  class NITC_perc;
  class NIT_perc;
  
  //                 //
 // class NITC_perc //
//                 //

  class NITC_perc : public NITC_linear
  {
  public:
    const Act *act;
    NITC_perc(const NITC_perc &that)
    : NITC_linear(that), act(that.act) {}
    NITC_perc(const Size &out_size_, Log *log_, W_FB *wf_,
              const Act &act_=Act::sigmoidal, bool bias_=true)
    : NITC_linear(out_size_,log_,wf_,bias_), act(&act_) {}
    NITC_perc(const Size &out_size_, Log *log_, W_FB *wf_, bool bias_)
    : NITC_linear(out_size_,log_,wf_,bias_), act(&Act::sigmoidal) {}
    NITC_perc(const Size &out_size_, W_FB *wf_, const Act &act_=Act::sigmoidal,
              bool bias_=true)
    : NITC_linear(out_size_,wf_,bias_), act(&act_) {}
    NITC_perc(const Size &out_size_, W_FB *wf_, bool bias_)
    : NITC_linear(out_size_,wf_,bias_), act(&Act::sigmoidal) {}
  };

  //                //
 // class NIT_perc //
//                //

  class NIT_perc : public NIT_linear
  {
  public:
    typedef NITC_perc      Common_t;
    typedef NE::Instance_t Instance_t;
    typedef NIT            Base_t;

  private:
    NIT_perc();
    NIT_perc(const NIT_perc &);

  protected:
    const Act *act;
    TERM       sum;
    TERM       sum_grad;
    char      *label_act;    

  public:
    NIT_perc(NITC_perc &c, const Init *inst);
    virtual ~NIT_perc();

    virtual Status      feed(const Term &in, Term &out);
    virtual void        feed_back(const Term &in, const Term &out,
                                  const Term *out_fb, Term *in_fb);
  };
  
  typedef F<NIT_perc> NIT_perc_F;

} //namespace ANN

#endif /* __ANN_NIT_PERC_H */

