/***************************************************************************
                          ann_nit_norm.h  -  description
                             -------------------
    begin                : sob wrz  6 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_NIT_NORM_H
#define __ANN_NIT_NORM_H

#include <ann_log.h>
#include <ann_factory.h>
#include <ann_to.h>

namespace ANN
{

  class NITC_norm;
  class NIT_norm;
  
  //                 //
 // class NITC_norm //
//                 //

  class NITC_norm 
  {
  public:
    Log    *log;
    double  bias;
    
    NITC_norm(const NITC_norm &that) : log(that.log), bias(that.bias) {}
    NITC_norm(Log *log_, double bias_=0) : log(log_), bias(bias_) {}
    NITC_norm(double bias_=0) : log(0), bias(bias_) {}
  };

  //                //
 // class NIT_norm //
//                //

  class NIT_norm : public NIT
  {
  public:
    typedef NITC_norm      Common_t;
    typedef NE::Instance_t Instance_t;
    typedef NIT            Base_t;

  private:
    NIT_norm();
    NIT_norm(const NIT_norm &);

  protected:
    Size    out_size;
    double  bias;
    double  norm;
    
  public:
    NIT_norm(NITC_norm &c, const Init *inst); 
    virtual ~NIT_norm();

    virtual const Size &get_out_sizes() const;
    virtual size_t      get_out_size() const;
    virtual Status      feed(const Term &in, Term &out);
    virtual bool        fb_accept(bool former) const;
    virtual void        feed_back(const Term &in, const Term &out,
                                  const Term *out_fb, Term *in_fb);
  };
  
  typedef F<NIT_norm> NIT_norm_F;

} //namespace ANN

#endif /* __ANN_NIT_NORM_H */

