/***************************************************************************
                          ann_nit_mlayer.h  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_NIT_MLAYER_H
#define __ANN_NIT_MLAYER_H

#include <vector>

#include <ann_to.h>
#include <ann_factory.h>

namespace ANN
{

  class NITC_mlayer;
  class NIT_mlayer;

  //                   //
 // class NITC_mlayer //
//                   //

  class NITC_mlayer
  {
  private:
    NITC_mlayer();

  public:
    NIT_FB **f;
    size_t   num;
    Log     *log;

    NITC_mlayer(NIT_FB **f_, Log *log_=0)
    : f(f_), num(0), log(log_) { while (f[num]) ++num; }
    NITC_mlayer(NIT_FB **f_, size_t num_, Log *log_=0)
    : f(f_), num(num_), log(log_) {}
    NITC_mlayer(const NITC_mlayer &that)
    : f(that.f), num(that.num), log(that.log) {}

    void drop_f() { while (num) delete f[--num]; }
    
    NITC_mlayer &operator = (const NITC_mlayer &that)
    { f=that.f; num=that.num; log=that.log; return *this; }
  };

  //                  //
 // class NIT_mlayer //
//                  //

  class NIT_mlayer : public NIT
  {
  protected:
    struct LayerData
    {
    public:
      NIT  *elem;
      TERM *in;
      bool  deep_fb;
      bool  shallow_fb;
      TERM *in_fb;

      LayerData(NIT &elem_, LayerData *former);
      ~LayerData()
      { if (elem) delete elem; if (in) delete in; if (in_fb) delete in_fb; }
    };
    typedef std::vector<LayerData *>  Layers;
    typedef Layers::iterator          L_it;
    typedef Layers::reverse_iterator  L_rit;
    typedef NITC_mlayer               Common_t;
    typedef NIT::Instance_t           Instance_t;
    typedef NIT                       Base_t;

  private:
    NIT_mlayer();
    NIT_mlayer(const NIT_mlayer &that);
    
  protected:  
    Layers layers;

    NIT_mlayer(Log &log_, Instance_t inst) : NIT(log_,inst) {}
    NIT_mlayer(Log *log_, Instance_t inst) : NIT(log_,inst) {}
    NIT_mlayer(Instance_t inst) : NIT(inst) {}

    bool add_layer(NIT *elem_);
    bool add_layer(NIT &elem_) { return add_layer(&elem_); }
    bool add_layer(NIT_FB *factory);
    bool add_layer(NIT_FB &factory) { return add_layer(&factory); }

    template<class Iterator>
    bool build(Iterator begin, Iterator end)
    {
      for (Iterator it=begin; it!=end; ++it) if (!add_layer(*it)) return false;
      return true;
    }
    bool build(NIT_FB **arr, size_t num)
    {
      for (size_t i=0; i<num; ++i) if (!add_layer(arr[i])) return false;
      return true;
    }
    bool build(NIT_FB **arr)
    {
      while (*arr) if (add_layer(*arr)) ++arr; else return false;
      return true;
    }

  public:
    template<class Iterator>
    NIT_mlayer(Instance_t inst, Log &log_, Iterator begin, Iterator end)
    : NIT(log_,inst) { build(begin,end); }
    template<class Iterator>
    NIT_mlayer(Instance_t inst, Log *log_, Iterator begin, Iterator end)
    : NIT(log_,inst) { build(begin,end); }
    template<class Iterator>
    NIT_mlayer(Instance_t inst, Iterator begin, Iterator end)
    : NIT(inst) { build(begin,end); }
    NIT_mlayer(Instance_t inst, Log &log_, NIT_FB **factory, size_t num)
    : NIT(log_,inst) { build(factory,num); }
    NIT_mlayer(Instance_t inst, Log *log_, NIT_FB **factory, size_t num)
    : NIT(log_,inst) { build(factory,num); }
    NIT_mlayer(Instance_t inst, NIT_FB **factory, size_t num)
    : NIT(inst) { build(factory,num); }
    NIT_mlayer(Instance_t inst, Log &log_, NIT_FB **factory)
    : NIT(log_,inst) { build(factory); }
    NIT_mlayer(Instance_t inst, Log *log_, NIT_FB **factory)
    : NIT(log_,inst) { build(factory); }
    NIT_mlayer(Instance_t inst, NIT_FB **factory)
    : NIT(inst) { build(factory); }
    NIT_mlayer(NITC_mlayer c, Instance_t inst)
    : NIT(c.log,inst) { build(c.f,c.num); }

    virtual ~NIT_mlayer();

    virtual const Size &get_out_sizes() const;
    virtual size_t      get_out_size() const;
    virtual Status      feed(const Term &in, Term &out);
    virtual void        reset(bool prod=false);
    virtual bool        load(Parser_log &parser, time_t begin=0,
                             time_t end=NAV_get(time_t));
    virtual void        store(Log &log_);
    virtual void        randomize();
    virtual void        register_weights(TO &school_);
    virtual Status      commence(DS &ds_, bool is_input);
    virtual void        conclude();
    virtual void        open();
    virtual Status      close();
    virtual bool        fb_accept(bool former) const;
    virtual void        feed_back(const Term &in, const Term &out,
                                  const Term *out_fb, Term *in_fb);

    template<class Iterator>
    static void drop_f(Iterator begin, Iterator end)
    { while(begin!=end) delete *begin++; }
    static void drop_f(NIT_FB **arr, size_t num)
    { for (size_t i=0; i<num; ++i) delete arr[i]; }
    static void drop_f(NIT_FB **arr)
    { while (*arr) delete *arr++; }
  };

  typedef F<NIT_mlayer> NIT_mlayer_F;
  
} // namespace ANN

#endif /* __ANN_NIT_MLAYER_H */
