/***************************************************************************
                          ann_nit_linear.h  -  description
                             -------------------
    begin                : sob wrz  6 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_NIT_LINEAR_H
#define __ANN_NIT_LINEAR_H

#include <ann_log.h>
#include <ann_factory.h>
#include <ann_to.h>
#include <ann_weight.h>

namespace ANN
{

  class NITC_linear;
  class NIT_linear;
  
  //                   //
 // class NITC_linear //
//                   //

  class NITC_linear
  {
  public:
    Log       *log;
    W_FB      *wf;
    Size       out_size;
    bool       bias;
    NITC_linear(const NITC_linear &that)
    : log(that.log), wf(that.wf), out_size(that.out_size), bias(that.bias) {}
    NITC_linear(const Size &out_size_, Log *log_, W_FB *wf_, bool bias_=true)
    : log(log_), wf(wf_), out_size(out_size_), bias(bias_) {}
    NITC_linear(const Size &out_size_, W_FB *wf_, bool bias_=true)
    : log(0), wf(wf_), out_size(out_size_), bias(bias_) {}
  };

  //                  //
 // class NIT_linear //
//                  //

  class NIT_linear : public NIT
  {
  public:
    typedef NITC_linear    Common_t;
    typedef NE::Instance_t Instance_t;
    typedef NIT            Base_t;

  private:
    NIT_linear();
    NIT_linear(const NIT_linear &);

  protected:
    Size  out_size;
    bool  bias;
    WA    w;
    TERM  w_grad;
    char *label_sum;    

  public:
    NIT_linear(NITC_linear &c, const Init *inst);
    virtual ~NIT_linear();

    virtual const Size &get_out_sizes() const;
    virtual size_t      get_out_size() const;
    virtual void        register_weights(TO &school);
    virtual Status      close();
    virtual Status      feed(const Term &in, Term &out);
    virtual bool        fb_accept(bool former) const;
    virtual void        feed_back(const Term &in, const Term &out,
                                  const Term *out_fb, Term *in_fb);
  };
  
  typedef F<NIT_linear> NIT_linear_F;

} //namespace ANN

#endif /* __ANN_NIT_LINEAR_H */

