/***************************************************************************
                          ann_eval_compet.h  -  description
                             -------------------
    begin                : pi wrz  5 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_EVAL_COMPET_H
#define __ANN_EVAL_COMPET_H

#include <ann_eval.h>

namespace ANN
{

  class EvalC_compet;
  class Eval_compet;
  
  //                    //
 // class EvalC_compet //
//                    //

  class EvalC_compet : public EvalC
  {
  public:
    bool  scalar;
    
    EvalC_compet(NIT_FB &f_, Log *log_, bool scalar_=false) 
    : EvalC(f_, log_), scalar(scalar_) {}
    EvalC_compet(NIT_FB &f_, bool scalar_=false) 
    : EvalC(f_), scalar(scalar_) {}
    EvalC_compet(NIT_FB *f_, Log *log_, bool scalar_=false) 
    : EvalC(f_, log_), scalar(scalar_) {}
    EvalC_compet(NIT_FB *f_, bool scalar_=false) 
    : EvalC(f_), scalar(scalar_) {}
    EvalC_compet(Log *log_, bool scalar_=false) : scalar(scalar_) {} 
    EvalC_compet(bool scalar_=false) : scalar(scalar_) {} 
    EvalC_compet(const EvalC_compet &that)
    : EvalC(that), scalar(that.scalar) {}
  };

  //                   //
 // class Eval_compet //
//                   //

  class Eval_compet : public Eval
  {
  public:
    typedef EvalC_compet   Common_t;
    typedef NE::Instance_t Instance_t;
    typedef NIT            Base_t;

  private:
    Eval_compet();
    Eval_compet(const Eval_compet &);

  protected:
    bool scalar;
    TERM comp;
    
  public:
    Eval_compet(NIT &ne_, bool scalar_, Log *log_, const char *label_=0);
    Eval_compet(NIT &ne_, bool scalar_, const char *label_=0);
    Eval_compet(NIT &ne_, Log *log_, const char *label_=0);
    Eval_compet(NIT &ne_, const char *label_=0);
    Eval_compet(NIT *ne_, bool scalar_, Log *log_, const char *label_=0);
    Eval_compet(NIT *ne_, bool scalar_, const char *label_=0);
    Eval_compet(NIT *ne_, Log *log_, const char *label_=0);
    Eval_compet(NIT *ne_, const char *label_=0);
    Eval_compet(Size in_size_, bool scalar_, Log *log_, const char *label_=0);
    Eval_compet(Size in_size_, bool scalar_, const char *label_=0);
    Eval_compet(Size in_size_, Log *log_, const char *label_=0);
    Eval_compet(Size in_size_, const char *label_=0);
    Eval_compet(EvalC_compet &c, const Init *inst);
    virtual ~Eval_compet();

    virtual const Size &get_out_sizes() const;
    virtual size_t      get_out_size() const;
    virtual Status      feed(const Term &in, Term &out);
    
    virtual void        feed_back(const Term &in, const Term &out,
                                  const Term *out_fb, Term *in_fb);
  };
  
  typedef F<Eval_compet> Eval_compet_F;

} //namespace ANN

#endif /* __ANN_EVAL_COMPET_H */

