/***************************************************************************
                          ann_ds_buff.h  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_DS_BUFF_H
#define __ANN_DS_BUFF_H

#include <ann_use_size_t.h>
#include <ann_loc.h>
#include <ann_ds.h>

namespace ANN
{

  class DS_buff; /* buffered data source */

  //               //
 // class DS_buff //
//               //

  class DS_buff : public virtual DS
  {
  private:
    TS          *data;
    Size         lengths;
    Term         current;
    Loc          loc;
    size_t       cur;
    static TERM  none;

  protected:
    DS_buff() : data(0), cur(0) {}
    
    void           rebuild(DS &that);
    void           rebuild(const Term &data_);
    void           rebuild(TS &data_);
    void           rebuild(TS *data_) { rebuild(*data_); }
    virtual bool   resize(const Size &sizes_);
    virtual bool   set_length(const Size &length_);
    virtual bool   set_limits(const Size &length_, const Size &sizes_);
    virtual TS    *all_terms();

    DS_buff &operator = (DS &that) { rebuild(that); return *this; }
    DS_buff &operator = (const Term &data_) { rebuild(data_); return *this; }
    DS_buff &operator = (TS &data_) { rebuild(data_); return *this; }
    
  public:
    DS_buff(DS &that) : data(0), cur(0) { rebuild(that); }
    DS_buff(const DS_buff &that)
    : data(that.data ? new TS(*that.data) : 0), lengths(that.lengths), cur(0)
    { data->locate(current,0); lengths.next(loc); }
    DS_buff(const Size &lengths_, const Size &sizes_)
    : data(new TS(lengths_,sizes_)), lengths(lengths_), cur(0)
    { data->locate(current,0); lengths.next(loc); }
    DS_buff(const Term &data_)  : data(0), cur(0) { rebuild(data_); }
    DS_buff(TS &data_) : data(0), cur(0) { rebuild(data_); }
    DS_buff(TS *data_) : data(0), cur(0) { rebuild(data_); }
    virtual ~DS_buff();
    
    virtual const Size &get_lengths() const;
    virtual size_t      get_length() const;
    virtual const Size &get_sizes() const; /* term sizes */
    virtual size_t      get_size() const;  /* returns overall term size */
    virtual bool        reset();
    virtual void        feed();
    virtual bool        seek(size_t term_pos_);
    virtual bool        locate(const Loc &loc_);
    virtual Term       &term();
    virtual const Term &term() const;
    virtual const Loc  &where() const;
    virtual size_t      which() const;
    virtual const TS   *all_terms() const;
 };

} // namespace ANN

#endif /* __ANN_DS_BUFF_H */
