/***************************************************************************
                          ann_time.cpp  -  description
                             -------------------
    begin                : pi kwi 18 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <string.h>
#include <stdio.h>

#include <ann_time.h>

  //                 //
 // class ANN::Time //
//                 //

ANN::Time::Buffer &
ANN::Time::Buffer::operator = (const Buffer &that)
{
  resize(that.length);
  strcpy(buffer,that.buffer);
  return *this;
}

ANN::Time ANN::Time::format;

ANN::Time::~Time()
{
}

size_t
ANN::Time::stamp(Buffer &buff)
{
  //field sizes         4 +2 +2 +2 +2 +2 +5 +6[separators] = 25
  static char  frm[] = "%Y.%m.%d %H:%M:%S %z";
  const size_t len=25;
  buff.resize(len);
  time_t t=time(0);
  return strftime(buff.c_str(),len+1,frm,localtime(&t));
}

time_t
ANN::Time::parse(const Buffer &buff)
{
  tzset();
  if (!buff.c_str()) return NAV_get(time_t);
  struct tm t;
  char      tz_sign;
  int       tz_hour, tz_min;
  t.tm_isdst=0;
  if (sscanf(buff.c_str(),"%u.%u.%u %u:%u:%u %c%2u%2u",
             &t.tm_year,&t.tm_mon,&t.tm_mday,
             &t.tm_hour,&t.tm_min,&t.tm_sec,
             &tz_sign,&tz_hour,&tz_min)!=9)
    return NAV_get(time_t);
  switch(tz_sign)
  {
  case '-':
    tz_sign=-60;
    break;
  case '+':
    tz_sign=60;
    break;
  default:
    return NAV_get(time_t);
  }
  return mktime(&t)-timezone+(tz_hour*60+tz_min)*tz_sign;
}

  //                      //
 // class ANN::Time_unix //
//                      //

ANN::Time_unix ANN::Time_unix::format;

ANN::Time_unix::~Time_unix()
{
}

size_t
ANN::Time_unix::stamp(Buffer &buff)
{
  buff.resize(sizeof(long)*3);
  long t(time(0));
  sprintf(buff.c_str(),"%ld",t);
  return strlen(buff.c_str());
}

time_t
ANN::Time_unix::parse(const Buffer &buff)
{
  if (!buff.c_str()) return NAV_get(time_t);
  long t;
  if (sscanf(buff.c_str(),"%ld",&t)!=1) return NAV_get(time_t);
  return time_t(t);
}

