/***************************************************************************
                          ann_tc.cpp  -  description
                             -------------------
    begin                : sob kwi 19 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <ann_tc.h>

  //                    //
 // class ANN::TC::Pos //
//                    //

void
ANN::TC::Pos::inc_level()
{
  if (++lev>loc.dim()) loc.resize(lev);
  loc[lev-1]=0;
}

bool
ANN::TC::Pos::dec_level()
{
  if (!lev) return false;
  if (!--lev) return false;
  ++loc[lev-1];
  return true;
}

  //               //
 // class ANN::TC //
//               //

ANN::TC::~TC()
{
}

void
ANN::TC::recalc()
{
  if (!lim_valid)
  {
    length.resize();
    size.resize();
    do_recalc();
    lim_valid=true;
  }
}

void
ANN::TC::put(const Loc &where, const Loc &loc, double val)
{
  do_put(*new Token(where,loc,val));
  lim_valid=false;
}

double
ANN::TC::get(const Loc &where, const Loc &loc)
{
  Token  t;
  size_t i, j;
  i=where.dim();
  for (;;)
  {
    t.where.resize(i,where.coord());
    j=loc.dim();
    for (;;)
    {
      t.loc.resize(j,loc.coord());
      if (do_get(t)) return t.val;
      if (!j) break;
      --j;
    }
    if (!i) break;
    --i;
  }  
  return NAN;
}

ANN::Term *
ANN::TC::get_term(const Loc &where)
{
  Term   *term=new Term(size);
  set_term(where,*term);
  return term;
}

void
ANN::TC::set_term(const Loc &where, Term &term)
{
  double *data=term.get_data();
  Loc     loc;
  while (term.get_sizes().next(loc)) *data++=get(where,loc);
}

void
ANN::TC::shrink(const Loc &where)
{
  do_shrink(Token(where));
  lim_valid=false;
}

void
ANN::TC::erase(const Loc &where)
{
  do_erase(Token(where));
  lim_valid=false;
}

void
ANN::TC::clear()
{
  do_clear();
  length.resize();
  size.resize();
  lim_valid=true;
}

/*
void
ANN::TC::recalc_size()
{
  size_t i;
  Size   tmp;
  lim.resize(0,0);
  for (i=0; i<num_term; ++i) if (calc_sizes(i,tmp)) lim.expand(tmp);
  i=lim.dim();
  while (i) if (lim[--i])
  {
    ++i;
    break;
  }
  lim.resize(i);
  lim_valid=true;
}

void
ANN::TC::reset()
{
  l=size_max;
  reserve(num_put);
}

void
ANN::TC::inc_level()
{
  if (l==size_max)
  {
    l=0;
    if (num_put>=num_term) num_term=num_put+1;
  }
  else ++l;
  if (l==cur.dim()) cur.resize(l+1);
  else cur[l]=0;
}

bool
ANN::TC::dec_level()
{
  if (!l || (l==size_max))
  {
    put_next();
    return false;
  }
  ++cur[--l];
  lim_valid=false;
  return true;
}

size_t
ANN::TC::put_next()
{
  num_put=num_term;
  reset();
  return num_put;
}

void
ANN::TC::put_at(size_t num)
{
  num_put=num;
  reset();
}

bool
ANN::TC::get_at(size_t num, Term &term)
{
  if (num>=num_term) return false;
  num_get=num;
  return get_next(term);
}
*/
