/***************************************************************************
                          ann_sink.cpp  -  description
                             -------------------
    begin                : nie maj 4 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <ann_sink.h>

  //                 //
 // class ANN::Sink //
//                 //

ANN::Sink::~Sink()
{
}

void
ANN::Sink::set_labels(const char *label_in_, const char *label_des_out_)
{
  if (label_in_) label_in.set_label(label_in_);
  else label_in.set_label("input__pattern");
  if (label_des_out_) label_des_out.set_label(label_des_out_);
  else
  {
    label_des_out.set_label(label_in_);
    label_des_out.set_label("desired_output",label_des_out.length());
  }
}

bool
ANN::Sink::store(DS &data, const char *label_in_, const char *label_des_out_)
{
  Size length(data.get_lengths());
  if (!length.total_size() || (length.total_size()==size_max)) return false;
  Loc  loc;
  bool ret=prepare(length,data.get_sizes(),label_in_,label_des_out_);
  bool use_next;
  data.reset();
  while (ret && length.next(loc))
  {
    use_next=!data.locate(loc);
    ret=feed(data.which(),data.where(),data.term(),
             data.des_output() ? &data.des_output()->term() : 0);
    if (use_next) data.next();
  }
  if (ret) ret=update();
  return ret;
}
