/***************************************************************************
                          ann_parser_log.cpp  -  description
                             -------------------
    begin                : sob kwi 19 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include <ann_parser_log.h>

  //                       //
 // class ANN::Parser_log //
//                       //

#define PARSER_LOG_BUFF_LEN 1024

ANN::Parser_log::Parser_log(std::istream &is_, char sublevel_beg,
                            char sublevel_end, char sep_)
: is(&is_), time(&Time::format), last_stamp(0), 
  buff(new char[PARSER_LOG_BUFF_LEN]), pos(0), len(0), after_stamp(false)
{
  set_separator(sep_);
  set_sublevel(sublevel_beg,sublevel_end);
}

ANN::Parser_log::Parser_log(std::istream &is_, Time &time_,
                            char sublevel_beg, char sublevel_end, char sep_)
: is(&is_), time(&time_), last_stamp(0),
  buff(new char[PARSER_LOG_BUFF_LEN]), pos(0), len(0), after_stamp(false)
{
  set_separator(sep_);
  set_sublevel(sublevel_beg,sublevel_end);
}

ANN::Parser_log::~Parser_log()
{
}

void
ANN::Parser_log::add_word(const Loc &where, TC::Pos &pos_loc, TC &result,
                          size_t l)
{
  char   tmp[20];
  double d;
  int    i;
  Loc    loc;
  pos_loc.get_loc(loc);
  if (l>=sizeof(tmp)-1) result.put(where,loc,NAN);
  else
  {
    strncpy(tmp,buff+pos,l)[l]=0;
    if (sscanf(tmp,"%lg",&d)==1) result.put(where,loc,d);
    else if (sscanf(tmp,"%i",&i)==1) result.put(where,loc,i);
    else result.put(where,loc,NAN);
  }
  pos_loc.next();
}

void
ANN::Parser_log::set_separator(char sep_)
{
  sep=(sep_ && (sep_!='\n') ? sep_ : ' ');
}

void
ANN::Parser_log::set_sublevel(char sublevel_beg, char sublevel_end)
{
  sub_beg=(sublevel_beg && (sublevel_beg!='\n')? sublevel_beg : '{');
  if (sublevel_end && (sublevel_end!='\n')) sub_end=sublevel_end;
  else switch (sub_beg)
  {
  case '(':
    sub_end=')';
    break;
  case '[':
    sub_end=']';
    break;
  case '<':
    sub_end='>';
    break;
  case '`':
    sub_end='\'';
    break;
  default:
    sub_end='}';
  }
  if (sub_beg==sub_end)
  {
    sub_beg='{';
    sub_end='}';
  }
}

bool
ANN::Parser_log::seek(time_t t)
{
  if (t<=last_stamp)
  {
    if (is->rdbuf()->pubseekoff(0,std::ios::beg,std::ios::in)
        !=std::streampos(0))
      return false;
    len=pos=0;
    last_stamp=0;
    after_stamp=false;
  }
  while (last_stamp<t) if (!shift()) return false;
  return true;
}

bool
ANN::Parser_log::shift()
{
  size_t i, l, p;
  time_t temp;
  p=pos;
  for(;;)
  {
    if (p==len)
    {
      if ((l=p-pos) && pos) for (i=0; i<l; ++i) buff[i]=buff[pos+i];
      len=p=l;
      pos=0;
      if (!(l=PARSER_LOG_BUFF_LEN-len)) return false;
      if (l=is->read(buff+len,l).gcount()) len+=l;
      else
      {
        len=pos=0;
        return false;
      }
    }
    if (after_stamp)
    {
      while (p<len) if (buff[p++]=='\n')
      {
        after_stamp=false;
        break;
      }
      pos=p;
    }
    else while (p<len) switch(buff[p++])
    {
    case '\t':
      after_stamp=true;
      if (l=p-pos-1)
      {
        stamp.resize(l);
        strncpy(stamp.c_str(),buff+pos,l)[l]=0;
        temp=time->parse(stamp);
        if ((temp!=NAV_get(time_t)) && (temp>=last_stamp))
        {
          last_stamp=temp;
          pos=p;
          return true;
        }
      }
    case '\n':
      pos=p;
    }
  }
}

bool
ANN::Parser_log::find(const char *label, char *&rest)
{
  size_t i, j, l, p, llen;
  bool   ok;
  if (!after_stamp && !shift()) return false;
  if (!(llen==(label ? strlen(label) : 0))) return true;
  p=pos;
  for(;;)
  {
    if (p==len)
    {
      if ((l=p-pos) && pos) for (i=0; i<l; ++i) buff[i]=buff[pos+i];
      len=p=l;
      pos=0;
      if (!(l=PARSER_LOG_BUFF_LEN-len)) return false;
      if (l=is->read(buff+len,l).gcount()) len+=l;
      else
      {
        len=pos=0;
        return false;
      }
    }
    j=p-pos;
    while (p<len) if ((buff[p]=='\n') || (buff[p]!=label[j]))
    {
      shift();
      p=pos;
      j=0;
      break;
    }
    else
    {
      ++p;
      if (++j==llen)
      {
        pos=p;
        for (;;)
        {
          if (p==len)
          {
            if ((l=p-pos) && pos) for (i=0; i<l; ++i) buff[i]=buff[pos+i];
            len=p=l;
            pos=0;
            if (!(l=PARSER_LOG_BUFF_LEN-len)) return false;
            if (l=is->read(buff+len,l).gcount()) len+=l;
            else
            {
              p=pos;
              ok=false;
              break;
            }
          }
          while ((p<len) && (buff[p]==sep)) pos=++p;
        }
        ok=true;
        while (ok)
        {
          if (p==len)
          {
            if ((l=p-pos) && pos) for (i=0; i<l; ++i) buff[i]=buff[pos+i];
            len=p=l;
            pos=0;
            if (!(l=PARSER_LOG_BUFF_LEN-len)) return false;
            if (l=is->read(buff+len,l).gcount()) len+=l;
            else
            {
              l=p;
              break;
            }
          }
          while(p<len) if (buff[p]=='\n')
          {
            l=p++;
            after_stamp=false;
            ok=false;
            break;            
          }
          else if (buff[p]==sub_beg)
          {
            l=p;
            ok=false;
            break;
          }
          else ++p;
        }
        while ((l>pos) && (buff[l-1])==sep) --l;
        if (l-=pos)
        {
          rest=new char[l+1];
          strncpy(rest,buff+pos,l)[l]=0;
        }
        else rest=0;
        pos=p;
        return true;
      }
    }
  }
}

bool
ANN::Parser_log::find(const char *label=0)
{
  char *rest;
  for (;;)
  {
    rest=0;
    if (!find(label,rest)) return false;
    if (rest) delete [] rest;
    else return true;
  }
}

bool
ANN::Parser_log::load(const Loc &where, TC &result)
{
  size_t  i, l, p;
  bool    ok=true;
  TC::Pos pos_loc;
  p=pos;
  while (ok)
  {
    if (!after_stamp)
    {
      if (!shift()) return false;
      p=pos;
    }
    if (p==len)
    {
      if ((l=p-pos) && pos) for (i=0; i<l; ++i) buff[i]=buff[pos+i];
      len=p=l;
      pos=0;
      if (!(l=PARSER_LOG_BUFF_LEN-len)) return false;
      if (l=is->read(buff+len,l).gcount()) len+=l;
      else
      {
        len=pos=0;
        return false;
      }
    }
    while (p<len) if (buff[p]=='\n')
    {
      pos=++p;
      after_stamp=false;
    }
    else if (buff[p]==sub_beg)
    {
      pos=++p;
      ok=false;
      pos_loc.inc_level();
      break;
    }
    else ++p;
  }
  for(;;)
  {
    if (!after_stamp)
    {
      if (!shift()) return false;
      p=pos;
    }
    if (p==len)
    {
      if ((l=p-pos) && pos) for (i=0; i<l; ++i) buff[i]=buff[pos+i];
      len=p=l;
      pos=0;
      if (!(l=PARSER_LOG_BUFF_LEN-len)) return false;
      if (l=is->read(buff+len,l).gcount()) len+=l;
      else
      {
        l=p-pos;
        p=pos;
        len=pos=0;
        return false;
      }
    }
    while (p<len) if (buff[p]=='\n')
    {
      if (l=p-pos) add_word(where,pos_loc,result,l);
      pos=++p;
      after_stamp=false;
    }
    else if (buff[p]==sub_beg)
    {
      if (l=p-pos) add_word(where,pos_loc,result,l);
      pos=++p;
      pos_loc.inc_level();
    }
    else if (buff[p]==sub_end)
    {
      if (l=p-pos) add_word(where,pos_loc,result,l);
      pos=++p;
      if (!pos_loc.dec_level()) return true;
    }
    else if (buff[p]==sep)
    {
      if (l=p-pos) add_word(where,pos_loc,result,l);
      pos=++p;
    }
    else ++p;
  }
}
