/***************************************************************************
                          ann_loc_io.cpp  -  description
                             -------------------
    begin                : nie maj 4 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <ann_loc_io.h>

std::ostream &
operator << (std::ostream &os, const ANN::Loc &l)
{
  os<< '<' <<l.dim() << '[';
  for (size_t i=0; i<l.dim(); ++i)
  {
    if (i) os << ',';
    os << l[i];
  }
  return os << "]>";
}

std::ostream &
operator << (std::ostream &os, const ANN::Size &s)
{
  os<< '<' <<s.dim() << '[';
  for (size_t i=0; i<s.dim(); ++i)
  {
    if (i) os << ',';
    if (s.total_size()==ANN::size_max) os << "INF"; else os << s[i];
  }
  os << ']';
  if (s.total_size()==ANN::size_max) os << "INF"; else os << s.total_size();
  return os << '>';
}

