/***************************************************************************
                          ann_ds_tee.cpp  -  description
                             -------------------
    begin                : wto kwi 15 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <string.h>
#include <stdio.h>
 
#include <ann_ds_tee.h>
#include <ann_init.h>

  //              //
 // class DS_tee //
//              //

ANN::DS_tee::DS_tee(DS &orig_, Sink &sink_, const char *label_in_,
                    const char *label_des_out_)
: DS_rec(orig_), sink(&sink_), label_in(Init::dup_str(label_in_)),
  label_des_out(Init::dup_str(label_des_out_)), active(false)
{  
}

ANN::DS_tee::~DS_tee()
{
  if (active) sink->update();
  if (label_in) delete [] label_in;
  if (label_des_out) delete [] label_des_out;
}

void ANN::DS_tee::log_term()
{
  if (active && (last!=where()))
  {
    active=sink->feed(which(),last=where(),input()->term(),
                      des_output() ? &des_output()->term() : 0);
    if (!active) sink->update();                  
  }
}

bool
ANN::DS_tee::do_reset()
{
  if (active) sink->update();
  bool ret=DS_rec::do_reset();
  active=sink->prepare(get_lengths(),get_sizes(),label_in,label_des_out);
  if (ret) log_term();
  return ret;
}

void
ANN::DS_tee::do_next()
{
  ANN::DS_rec::do_next();
  log_term();
}

bool
ANN::DS_tee::do_seek(size_t term_pos_)
{
  bool ret=ANN::DS_rec::do_seek(term_pos_);
  if (ret) log_term();
  return ret;
}

bool
ANN::DS_tee::do_locate(const Loc &loc)
{
  bool ret=ANN::DS_rec::do_locate(loc);
  if (ret) log_term();
  return ret;
}
