/***************************************************************************
                          ann_ds_log.cpp  -  description
                             -------------------
    begin                : pon kwi 21 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <string.h>
#include <stdio.h>

#include <ann_ds_log.h>
#include <ann_tc.h>

  //                   //
 // class ANN::DS_log //
//                   //

ANN::DS_log::DS_log(Parser_log &parser, const char *label, const char *l_in,
                    const char *l_des_out, time_t begin, time_t end)
{
  char *tail, sep=parser.get_separator(), *str;
  TC   *tc_in=TC::create(), *tc_des_out=TC::create(), *tc;
  Loc   where(1,size_t(0));
  if (!l_in) l_in="input";
  if (!l_des_out) l_des_out="desired output";
  size_t len_in=strlen(l_in);
  size_t len_des_out=strlen(l_des_out);  
  if ((begin==NAV_get(time_t)) || parser.seek(begin))
  {
    while (parser.find(label,tail)) if (tail)  
    {
      if ((end==NAV_get(time_t)) || (parser.when()<=end))
        if (!strncmp(tail,l_in,len_in))
        {
          tc=tc_in;
          str=tail+len_in;
        }  
        else if (!strncmp(tail,l_des_out,len_des_out))
        {
          tc=tc_des_out;
          str=tail+len_des_out;
        }  
        else
        {
          tc=0;
          str=0;
        }  
      if (str) while(*str==sep) ++str;  
      if (tc && *str && (sscanf(str,"%lu",where.coord()))==1)  
      {
        if (!parser.load(where,*tc)) tc->erase(where);
        else if ((end!=NAV_get(time_t)) && (end<parser.when())) tc->erase(where);
      }
      delete [] tail;
    }
    import(tc_in,tc_des_out);
  }
  delete tc_in;
  delete tc_des_out;
}

