/***************************************************************************
                          ann_ds_buff.cpp  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <math.h>
#include <ann_ds_buff.h>

  //                    //
 // class ANN::DS_buff //
//                    //

ANN::Term ANN::DS_buff::nan;

ANN::DS_buff::~DS_buff()
{
}

void
ANN::DS_buff::import(TC *in_, TC *des_out_)
{
  if (in_)
  {
    Size  lengths(in_->get_lengths());
    TS   *data_;
    if (des_out_ && des_out_->get_size())
    {
      lengths.expand(des_out_->get_lengths());
      des_out_->expand(lengths);
      in_->expand(lengths);
    }
    set_length(lengths);
    if (data_=inp_terms()) data_->import(*in_);
    if (!des_out_ || !des_out_->get_size()) des_drop();
    else
    {
      des_resize(des_out_->get_size());
      if (data_=des_terms()) data_->import(*des_out_);
    }
  }  
  reset();  
}

bool
ANN::DS_buff::do_resize(const Size &sizes_)
{
  data.term_resize(sizes_);
  return true;
}

bool
ANN::DS_buff::do_set_length(const Size &len_)
{
  data.resize(len_);
  return true;
}

bool
ANN::DS_buff::do_reset()
{
  current=0;
  loc.resize();
  return data.get_lengths().next(loc);
}

void
ANN::DS_buff::do_next()
{
  if (++current>=data.get_length())
  {
    current=0;
    loc.resize();
  }
  data.get_lengths().next(loc);
}

bool
ANN::DS_buff::do_seek(size_t term_pos_)
{
  if (term_pos_<data.get_length()
      && data.get_lengths().locate(current=term_pos_,loc))
    return true;
  current=size_max;
  loc.resize();
  return false;
}

bool
ANN::DS_buff::do_locate(const Loc &loc_)
{
  if ((current=data.get_lengths()[loc_])!=size_max)
  {
    loc=loc_;
    return true;
  }
  loc.resize();
  return false;
}

const ANN::Size &
ANN::DS_buff::get_lengths() const
{
  return data.get_lengths();
}

size_t
ANN::DS_buff::get_length() const
{
  return data.get_length();
}

const ANN::Size &
ANN::DS_buff::get_sizes() const
{
  return data.get_term_sizes();
}

size_t
ANN::DS_buff::get_size() const
{
  return data.get_term_size();
}

ANN::Term &
ANN::DS_buff::term()
{
  if (current<data.get_length()) return *data[current];
  nan.resize(Size());
  return nan;
}

const ANN::Term &
ANN::DS_buff::term() const
{
  if (current<data.get_length()) return *data[current];
  nan.resize(Size());
  return nan;
}

const ANN::Loc &
ANN::DS_buff::where() const
{
  return loc;
}

size_t
ANN::DS_buff::which() const
{
  return current;
}

ANN::TS *
ANN::DS_buff::all_terms()
{
  return &data;
}

const ANN::TS *
ANN::DS_buff::all_terms() const
{
  return &data;
}

  //                        //
 // class ANN::DS_buff_des //
//                        //

ANN::DS_buff_des::~DS_buff_des()
{
}

const ANN::Size &
ANN::DS_buff_des::get_lengths() const
{
  return in->get_lengths();
}

size_t
ANN::DS_buff_des::get_length() const
{
  return in->get_length();
}

const ANN::Loc &
ANN::DS_buff_des::where() const
{
  return in->where();
}

size_t
ANN::DS_buff_des::which() const
{
  return in->which();
}

