/***************************************************************************
                          ann_sink_xpm.h  -  description
                             -------------------
    begin                : nie maj 4 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_SINK_XPM_H
#define __ANN_SINK_XPM_H

#include <ann_sink.h>

namespace ANN
{

  class Sink_xpm;

  //                //
 // class Sink_xpm //
//                //

  class Sink_xpm : public Sink
  {
  private:
    Sink_xpm(const Sink_xpm &that);

  protected:
    Label         var_in;
    Label         var_des_out;
    size_t        len_l_in;
    size_t        len_l_des_out;
    size_t        len_v_in;
    size_t        len_v_des_out;
    double        black;
    double        delta;

  public:
    Sink_xpm(double black_, double white_)
    : black(black_), delta(white_-black_) {}
    Sink_xpm(double white_=1) : black(0), delta(white_) {}
    virtual ~Sink_xpm();

    virtual bool prepare(Size lengths, Size sizes, const char *label_in_=0,
                         const char *label_des_out_=0);
    virtual bool feed(size_t which_, const Loc &where_, const Term &in,
                      const Term *des_out);
    virtual bool update();
  };

} // namespace ANN

#endif /* __ANN_SINK_XPM_H */
