/***************************************************************************
                          ann_sink_ws.h  -  description
                             -------------------
    begin                : nie maj 4 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_SINK_WS_H
#define __ANN_SINK_WS_H

#include <ann_sink.h>
#include <iostream>

namespace ANN
{

  class Sink_ws;

  //               //
 // class Sink_ws //
//               //

  class Sink_ws : public Sink
  {
  private:
    Sink_ws();
    Sink_ws(const Sink_ws &that);
    
  protected:
    std::ostream *os;
    
  public:
    Sink_ws(std::ostream &os_) : os(&os_) {}
    virtual ~Sink_ws();

    virtual bool prepare(Size lengths, Size sizes, const char *label_in_=0,
                         const char *label_des_out_=0);
    virtual bool feed(size_t which_, const Loc &where_, const Term &in,
                      const Term *des_out);
    virtual bool update();    
  };

} // namespace ANN

#endif /* __ANN_SINK_WS_H */
