/***************************************************************************
                          ann_sink.h  -  description
                             -------------------
    begin                : nie maj 4 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_SINK_H
#define __ANN_SINK_H

#include <ann_term.h>
#include <ann_ds.h>
#include <ann_init.h>

namespace ANN
{

  class Sink;
  
  //            //
 // class Sink //
//            //

  class Sink
  {
  private:
    Sink(const Sink &that);

  protected:
    Label label_in;
    Label label_des_out;
    
    Sink() {}

    void set_labels(const char *label_in_=0, const char *label_des_out_=0);
    
  public:
    virtual ~Sink();

    virtual bool prepare(Size lengths, Size sizes, const char *label_in_=0,
                         const char *label_des_out_=0)=0;
    virtual bool feed(size_t which_, const Loc &where_, const Term &in,
                      const Term *des_out)=0;
    virtual bool update()=0;

    virtual bool store(DS &data, const char *label_in=0,
                       const char *label_des_out=0);    
  };  
    
} // namespace ANN

#endif /* __ANN_SINK_H */
