/***************************************************************************
                          ann_ne.h  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_NE_H
#define __ANN_NE_H

#include <ctype.h>

#include <ann_loc.h>
#include <ann_init.h>
#include <ann_term.h>
#include <ann_ds.h>
#include <ann_factory.h>

namespace ANN
{
  class NE;
}

#include <ann_weight.h>
#include <ann_to.h>
#include <ann_log.h>

namespace ANN
{

  //          //
 // class NE //
//          //

  class NE
  {
  public:
    typedef Log         Common_t;
    typedef const Init *Instance_t;
    typedef NE          Base_t;

  private:
    NE();
    NE(const NE &that);

  protected:
    const char        *label;
    Size               in_size;
    Log               *log;
    static const Size  single_out_size;

    NE(Size in_size_, Log *log_=0, const char *label_=0);
    NE(Size in_size_, const char *label_);
    NE(Log &log_, Instance_t inst)
    : label(inst->dup_label()), in_size(inst->size), log(&log_) {}
    NE(Log *log_, Instance_t inst)
    : label(inst->dup_label()), in_size(inst->size), log(log_) {}
    NE(Instance_t inst)
    : label(inst->dup_label()), in_size(inst->size), log(0) {}

  public:
    virtual ~NE();

    const Size           &get_in_sizes() const { return in_size; }
    const size_t          get_in_size() const { return in_size.total_size(); }
    virtual const Size   &get_out_sizes() const;
    virtual const size_t  get_out_size() const;
    virtual void          calc(const Term &in, Term &out)=0;
    
    /* Low level adaptation routines */
    virtual bool          is_supervised() const=0;
    /* tells whether adapt() method requires out_bp */
    virtual void          reset(TO &t, bool b_reload=false)=0;
    /* element moves its state to the very begining of adaptation */
    virtual void          prepare(TO &t);
    /* called every time epoch starts */
    virtual int           update(TO &t);
    /* called every time epoch ends, returns 1 if the element need no more
     * training, -1 if the element need more trainig and 0 it the element
     * cannot asses */
    virtual void          finish(TO &t);
    /* called when training is finished */
    virtual void          adapt(const Term &in, const Term &out,
                                const Term *out_bp, Term *in_bp)=0;
    /* called after each presentation, should backpropagate errors (if needed)
     * and calculate weights' partial changes/gradients */
    virtual bool          load(Parser_log &parser, time_t begin=0,
                               time_t end=NAV_get(time_t)); 
    virtual void          store(Log &log_);                  
  };

  typedef FB<NE,const Init *> NE_FB;
  
} //namespace ANN

#endif /* __ANN_NE_H */
