/***************************************************************************
                          ann_factory.h  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_FACTORY_H
#define __ANN_FACTORY_H

namespace ANN
{

  template<class Base, class Instance=typename Base::Instance_t>
  class FB; /* Factory Base */
  template<class Item, class Common=typename Item::Common_t,
           class Instance=typename Item::Instance_t,
           class Base=typename Item::Base_t>
  class F;  /* Factory */
  
  //template<class Base, class Instance>//
 // class FB                           //
//                                    //

  template<class Base, class Instance>
  class FB
  {
  public:
    typedef Base     Base_t;
    typedef Instance Instance_t;

    FB() {}
    virtual ~FB() {}

    virtual Base_t *create(Instance_t instance)=0;
    Base_t *operator() (Instance_t instance) { return create(instance); }
  };

  template<class Base>
  class FB<Base,void>
  {
  public:
    typedef Base Base_t;
    typedef void Instance_t;

    FB() {}
    virtual ~FB() {}

    virtual Base_t *create()=0;
    Base_t *operator() () { return create(); }
  };

  //template<class Item, class Common, class Instance, class Base>//
 // class F                                                      //
//                                                              //

  template<class Item, class Common, class Instance, class Base>
  class F : public virtual FB<Base,Instance>
  {
  public:
    typedef Item     Item_t;
    typedef Common   Common_t;
    typedef Instance Instance_t;
    typedef Base     Base_t;

  protected:
    Common_t *common;
    
  public:
    F() : common(0) {}
    F(const F &that) : common(that.common) {}
    F(Common_t &common_) : common(&common_) {}
    F(Common_t *common_) : common(common_) {}

    virtual Base_t *create(Instance_t instance)
    { return new Item(*common,instance); }
    
  };

  template<class Item, class Instance, class Base>
  class F<Item,void,Instance,Base> : public virtual FB<Base,Instance>
  {
  public:
    typedef Item     Item_t;
    typedef void     Common_t;
    typedef Instance Instance_t;
    typedef Base     Base_t;

    F() {}
    F(const F &that) {}

    virtual void    created(Item_t *item, Instance_t instance) {}
    virtual Base_t *create(Instance_t instance)
    { return new Item(instance); }
  };

  template<class Item, class Common, class Base>
  class F<Item,Common,void,Base> : public virtual FB<Base,void>
  {
  public:
    typedef Item   Item_t;
    typedef Common Common_t;
    typedef void   Instance_t;
    typedef Base   Base_t;

  protected:
    Common_t *common;

  public:
    F() : common(0) {}
    F(const F &that) : common(that.common) {}
    F(Common_t &common_) : common(&common_) {}
    F(Common_t *common_) : common(common_) {}

    virtual Base_t *create()
    { return new Item(*common); }
  };

  template<class Item, class Base>
  class F<Item,void,void,Base> : public virtual FB<Base,void>
  {
  public:
    typedef Item Item_t;
    typedef void Common_t;
    typedef void Instance_t;
    typedef Base Base_t;

    F() {}
    F(const F &that) {}

    virtual Base_t *create() 
    { return new Item; }
  };

} // namespace ANN

#endif /* __ANN_FACTORY_H */

