/***************************************************************************
                          ann_ds_buff.h  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_DS_BUFF_H
#define __ANN_DS_BUFF_H

#include <ctype.h>

#include <ann_loc.h>
#include <ann_ds.h>
#include <ann_tc.h>

namespace ANN
{

  class DS_buff;      /* buffered data source */
  class DS_buff_des;  /* buffered data source for desired output */

  //               //
 // class DS_buff //
//               //

  class DS_buff : public virtual DS
  {
  private:
    TS           data;
    Loc          loc;
    size_t       current;
    static Term  nan;

    DS_buff(const DS_buff &that);

  protected:
    DS_buff() : current(0) {}
    DS_buff(const Size &lengths_, const Size &sizes_)
    : data(lengths_,sizes_), current(0) {}
    virtual ~DS_buff();

    void           import(TC *in_, TC *des_out_);
    virtual bool   do_resize(const Size &sizes_);
    virtual bool   do_set_length(const Size &len_);
    virtual bool   do_reset();
    virtual void   do_next();
    virtual bool   do_seek(size_t term_pos_);
    virtual bool   do_locate(const Loc &loc_);
    virtual TS    *all_terms();
    inline bool    des_resize(const Size &sizes_);

  public:
    DS_buff(TC &in_, TC &des_out_)
    : current(size_max) { import(&in_,&des_out_); }
    DS_buff(TC *in_, TC *des_out_)
    : current(size_max) { import(in_,des_out_); }
    
    virtual const Size &get_lengths() const;
    virtual size_t      get_length() const;
    virtual const Size &get_sizes() const; /* term sizes */
    virtual size_t      get_size() const;  /* returns overall term size */
    virtual Term       &term();
    virtual const Term &term() const;
    virtual const Loc  &where() const;
    virtual size_t      which() const;
    virtual const TS   *all_terms() const;

 };

  //                   //
 // class DS_buff_des //
//                   //

  class DS_buff_des : public DS_buff, public DS_des
  {
  public:
    DS_buff_des(DS &in_)
    : DS(this), DS_buff(), DS_des(in_) {}
    DS_buff_des(DS &in_, const Size &sizes_)
    : DS(this), DS_buff(in_.get_lengths(),sizes_), DS_des(in_) {}
    virtual ~DS_buff_des();

    virtual const Size &get_lengths() const;
    virtual size_t      get_length() const;
    virtual const Loc  &where() const;
    virtual size_t      which() const;
  };

} // namespace ANN

bool
ANN::DS_buff::des_resize(const Size &sizes_)
{
  if (des_out) return ANN::DS_buff::des_resize(sizes_);
  des_out=new DS_buff_des(*this,sizes_);
  return true;
}

#endif /* __ANN_DS_BUFF_H */
