/***************************************************************************
                          ann_array.h  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_ARRAY_H
#define __ANN_ARRAY_H

#include <ctype.h>
#include <math.h>

#include <ann_nav.h>
#include <ann_loc.h>

namespace ANN
{

  template<class Elem, class Item=Elem>
  class Array;

  //template<class Elem, class Item>//
 // class Array                    //
//                                //

  template<class Elem, class Item>
  class Array
  {
  public:
    typedef Elem Elem_t;
    typedef Item Item_t;
    
  protected:
    Size           size;
    Elem          *data;
    static Elem    nav;

    virtual void do_fetch(size_t size_, const Item_t *data_);
    
  public:
    virtual bool resize(const Size &limits, bool keep=true);
    void         fetch(size_t size_, const Item_t *data_)
    { do_fetch(size_,data_); }
    void         fetch(const Item_t *data_)
    { do_fetch(size.total_size(),data_); }

    Array() : data(0) {}
    Array(const Size &size_) : data(0) { resize(size_); }
    Array(const Array &that)
    : data(0) { resize(that.size,false); fetch(that.data); }
    Array(size_t size_, const Item_t *data_=0)
    : size(size_), data(size_ ? new Elem_t[size_] : 0)
    { fetch(data_ ? size_ : 0, data_); }

    virtual ~Array();

    const Size   &get_sizes() const { return size; }
    size_t        get_size() const { return size.total_size(); }
    Elem_t       &at(size_t idx)
    { return idx<size.total_size() ? data[idx] : NAV_set(nav); }
    Item_t        at(size_t idx) const
    { return idx<size.total_size() ? data[idx] : NAV_get(Elem); }
    Elem_t       &at(const Loc &loc) { return at(size.index(loc)); }
    Item_t        at(const Loc &loc) const { return at(size.index(loc)); }
    Elem_t       *get_data() { return data; }
    const Item_t *get_data() const { return data; }

    Elem_t &operator [] (size_t idx) { return at(idx); }
    Item_t  operator [] (size_t idx) const { return at(idx); }
    Elem_t &operator [] (const Loc &loc) { return at(loc); }
    Item_t  operator [] (const Loc &loc) const { return at(loc); }
    Array  &operator = (const Array &arr)
    { resize(arr.size,false); fetch(arr.data); return *this; }

    template<class E, class I>
    static inline void clone_elem(E &e, I i) { e=i; }
    template<class E>
    static inline void clone_elem(E *&e, const E *i) { e=new E(*i); }
  };

} // namespace ANN

template<class Elem, class Item>
Elem ANN::Array<Elem,Item>::nav;

template<class Elem, class Item>
ANN::Array<Elem,Item>::~Array()
{
  if (data) delete [] data;
}

template<class Elem, class Item>
bool
ANN::Array<Elem,Item>::resize(const Size &limits, bool keep)
{
  size_t i, n=size.total_size(), n_=limits.total_size();
  bool   ret=(n==n_);
  if (!ret)
  {
    Elem *tmp=((n_) ? new Elem[n_] : 0);
    if (keep)
    {
      if (n>n_) n=n_;
      for (i=0; i<n; ++i) tmp[i]=data[i];
      for (i=n; i<n_; ++i) NAV_set(tmp[i]);
    }
    if (data) delete [] data;
    data=tmp;
  }
  size=limits;
  return ret;
}

template<class Elem, class Item>
void
ANN::Array<Elem,Item>::do_fetch(size_t size_, const Item *data_)
{
  size_t i;
  if (size_>size.total_size()) size_=size.total_size();
  for (i=0; i<size_; ++i) clone_elem(data[i],data_[i]);
  for (i=size_; i<size.total_size(); ++i) NAV_set(data[i]);
}

#endif /* __ANN_ARRAY_H */
