/***************************************************************************
                          ann_act.h  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_ACT_H
#define __ANN_ACT_H

namespace ANN
{

  class Act;
  class Act_sigmoidal;
  class Act_linear;
  
  //           //
 // class Act //
//           //

  class Act
  {
  public:
    virtual ~Act() {}
    virtual double fun(double x) const=0;
    virtual double deriv(double x, double y) const=0;
    double operator() (double x) const { return fun(x); }
    double operator() (double x, double y) const { return deriv(x,y); }

    static Act_sigmoidal sigmoidal;  
    static Act_linear    linear;
  };
  
  //                     //
 // class Act_sigmoidal //
//                     //

  class Act_sigmoidal : public Act
  {
  public:
    virtual double fun(double x) const;
    virtual double deriv(double x, double y) const;
  };
  
  //                  //
 // class Act_linear //
//                  //

  class Act_linear : public Act
  {
  public:
    virtual double fun(double x) const;
    virtual double deriv(double x, double y) const;
  };

} //namespace ANN

#endif /* __ANN_ACT_H */

