/***************************************************************************
                          ann_tc.cpp  -  description
                             -------------------
    begin                : sob kwi 19 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <ann_tc.h>

ANN::TC::~TC()
{
}

void
ANN::TC::recalc_size()
{
  size_t i;
  Size   tmp;
  lim.resize(0,0);
  for (i=0; i<num_term; ++i) if (calc_sizes(i,tmp)) lim.expand(tmp);
  i=lim.dim();
  while (i) if (lim[--i])
  {
    ++i;
    break;
  }
  lim.resize(i);
  lim_valid=true;
}

void
ANN::TC::reset()
{
  l=size_max;
  reserve(num_put);
}

void
ANN::TC::inc_level()
{
  if (l==size_max)
  {
    l=0;
    if (num_put>=num_term) num_term=num_put+1;
  }
  else ++l;
  if (l==cur.dim()) cur.resize(l+1);
  else cur[l]=0;
}

bool
ANN::TC::dec_level()
{
  if (!l || (l==size_max))
  {
    put_next();
    return false;
  }
  ++cur[--l];
  lim_valid=false;
  return true;
}

size_t
ANN::TC::put_next()
{
  num_put=num_term;
  reset();
  return num_put;
}

void
ANN::TC::put_at(size_t num)
{
  num_put=num;
  reset();
}

bool
ANN::TC::get_at(size_t num, Term &term)
{
  if (num>=num_term) return false;
  num_get=num;
  return get_next(term);
}
