/***************************************************************************
                          ann_ne_perc.cpp  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <ann_ne_perc.h>

  //               //
 // class NE_perc //
//               //

ANN::NE_perc::NE_perc(NEC_perc &c, const Init *inst)
: NE(c.log,inst), out_size(c.out_size), bias(c.bias), w(c.out_size), act(c.act),
  sum(c.out_size)
{
  size_t in_len=inst->size->total_size()+bias;
  size_t out_len=c.out_size.total_size();
  Size w_size(1,&in_len);
  Init sub_inst(w_size,label);
  sub_inst.set_label("neuron",sub_inst.length());
  size_t pos=sub_inst.length(), i;
  for (i=0; i<out_len; ++i)
  {
    sub_inst.set_index(i,pos);
    sub_inst.set_label("weights",sub_inst.length());
    w[i]=c.wf->create(&sub_inst);
  }
}

ANN::NE_perc::~NE_perc()
{
  W::drop_weights(w);
}

const ANN::Size &
ANN::NE_perc::get_out_sizes() const
{
  return out_size;
}

bool
ANN::NE_perc::is_supervised() const
{
  return true;
}

void
ANN::NE_perc::reset(TO &t, bool b_reload)
{
  if (b_reload)
  {
    size_t i, n=out_size.total_size();
    for (i=0; i<n; ++i) t.register_weight(*w[i]);
  }
}

void
ANN::NE_perc::calc(const Term &in, Term &out)
{
  size_t        i, n=out_size.total_size();
  size_t        j, m=in_size.total_size();
  const double *x=in.get_data(), *u;
  double       *X=sum.get_data();
  for (i=0; i<n; ++i)
  {
    u=w[i]->values().get_data();
    X[i]=(bias ? u[m] : 0);
    for (j=0; j<m; ++j) X[i]+=x[j]*u[j];
    out[i]=(*act)(X[i]);
  }
  if (log && log->is_active()) log->log(out,label);
}

void
ANN::NE_perc::adapt(const Term &in, const Term &out,
                       const Term *out_err, Term *in_err)
{
  size_t        i, n=out_size.total_size();
  size_t        j, m=in_size.total_size()+bias;
  Term          grad(1,&m);
  const double *u, *x=in.get_data(), *y=out.get_data(), *e=out_err->get_data();
  double       *X=sum.get_data(), *d=grad.get_data(), E, *e_;  
  if (bias) --m;
  if (in_err)
  {
    e_=in_err->get_data();
    for (j=0; j<m; ++j) e_[j]=0;
  }  
  for (i=0; i<n; ++i)
  {
    E=e[i]*(*act)(X[i],y[i]);
    u=w[i]->values().get_data();
    if (bias) d[m]=-E;
    for (j=0; j<m; ++j)
    {
      if (in_err) e_[j]+=E*u[j];
      d[j]=-E*x[j];
    }  
    w[i]->adapt(grad);
  }
}

