/***************************************************************************
                          ann_loc.cpp  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <ann_loc.h>

  //                //
 // class ANN::Loc //
//                //

size_t ANN::Loc::nav=ANN::size_max;

ANN::Loc::~Loc()
{
  if (coordinates) delete [] coordinates;
}

size_t
ANN::Loc::get_dim(const size_t *coordinates_)
{
  size_t dimension_=0;
  if (coordinates_)
    while (coordinates_[dimension_]!=ANN::size_max) ++dimension_;
  return dimension_;
}

void
ANN::Loc::resize(size_t dimension_, const size_t *coordinates_)
{
  size_t i;
  if (dimension!=dimension_)
  {
    size_t *tmp;
    if (dimension_)
    {
      tmp=new size_t[dimension_];
      if (coordinates_)
        for (i=0; i<dimension_; ++i) tmp[i]=coordinates_[i];
      else if (dimension<dimension_)
      {
        for (i=0; i<dimension; ++i) tmp[i]=coordinates[i];
        for (i=dimension; i<dimension_; ++i) tmp[i]=0;
      }
      else for (i=0; i<dimension_; ++i) tmp[i]=coordinates[i];
    }
    if (coordinates) delete [] coordinates;
    coordinates=((dimension=dimension_) ? tmp : 0);
  }
  else if (coordinates_)
    for (i=0; i<dimension; ++i) coordinates[i]=coordinates_[i];
}

size_t
ANN::Loc::product() const
{
  size_t i, prod=1;
  for (i=0; i<dimension; ++i) prod*=coordinates[i];
  return prod;
}

ANN::Loc &
ANN::Loc::expand(const Loc &that)
{
  size_t *result, min, i;
  if (dimension<that.dim())
  {
    result=new size_t[that.dim()];
    min=dimension;
  }
  else
  {
    result=coordinates;
    min=that.dim();
  }
  for (i=0; i<min; ++i)
    result[i]=(coordinates[i]>that[i] ? coordinates[i] : that[i]);
  if (result!=coordinates)
  {
    dimension=that.dim();
    for(i=min; i<dimension; ++i) result[i]=that[i];
    if (coordinates) delete [] coordinates;
    coordinates=result;
  }
  return *this;
}

void
ANN::Loc::clear()
{
  for (size_t i=0; i<dimension; ++i) coordinates[i]=0;
}

  //                 //
 // class ANN::Size //
//                 //

void
ANN::Size::resize(size_t dimension_, const size_t *coordinates_)
{
  size_t i;
  if (dimension!=dimension_)
  {
    size_t *tmp;
    if (dimension_)
    {
      tmp=new size_t[dimension_];
      if (coordinates_)
      {
        total=1;
        for (i=0; i<dimension_; ++i) total*=(tmp[i]=coordinates_[i]);   
      }  
      else if (dimension<dimension_)
      {
        total=0;
        for (i=0; i<dimension; ++i) tmp[i]=coordinates[i];
        for (i=dimension; i<dimension_; ++i) tmp[i]=0;
      }
      else
      {
        total=1;
        for (i=0; i<dimension_; ++i) total*=(tmp[i]=coordinates[i]);
      }
    }
    else total=0;
    if (coordinates) delete [] coordinates;
    coordinates=((dimension=dimension_) ? tmp : 0);
  }
  else if (coordinates_)
  {
    total=1;
    for (i=0; i<dimension; ++i) total*=(coordinates[i]=coordinates_[i]);
  }  
}

ANN::Size &
ANN::Size::expand(const Loc &that)
{
  size_t *result, min, i;
  if (dimension<that.dim())
  {
    result=new size_t[that.dim()];
    min=dimension;
  }
  else
  {
    result=coordinates;
    min=that.dim();
  }
  for (i=0; i<min; ++i)
    result[i]=(coordinates[i]>that[i] ? coordinates[i] : that[i]+1);
  if (result!=coordinates)
  {
    dimension=that.dim();
    for(i=min; i<dimension; ++i) result[i]=that[i];
    if (coordinates) delete [] coordinates;
    coordinates=result;
  }
  reset();
  return *this;
}

ANN::Size &
ANN::Size::expand(const Size &that)
{
  Loc::expand(that);
  reset();
  return *this;
}

size_t
ANN::Size::index(const Loc &loc) const
{
  size_t l_dim=loc.dim();
  if (l_dim>dimension) return ANN::size_max;
  size_t i, idx=0, crdnt, limit;
  for (i=0; i<l_dim; ++i) if ((crdnt=loc[i])<(limit=coordinates[i]))
    (idx*=limit)+=crdnt;
  else return ANN::size_max;
  while (i<dimension) idx*=coordinates[i++];
  return idx;
}

void
ANN::Size::reset()
{
  total=(dimension ? ANN::Loc::product() : 0);
}

void 
ANN::Size::set(size_t which_dim, size_t size_)
{
  bool prod=!dimension;
  if (dimension<=which_dim)
  {
    size_t i, *tmp=new size_t[which_dim+1];
    for (i=0; i<dimension; ++i) tmp[i]=coordinates[i];
    if (dimension<which_dim)
    {
      for (i=dimension; i<which_dim; ++i) tmp[i]=0;
      total=0;
    }
    if (coordinates) delete [] coordinates;
    coordinates=tmp;
    dimension=which_dim+1;
  }
  else if (coordinates[which_dim]) total/=coordinates[which_dim];
  else prod=true;
  coordinates[which_dim]=size_;
  if (prod) total=ANN::Loc::product(); else total*=size_;
}
