/***************************************************************************
                          ann_ds_rnd.cpp  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdlib.h>
#include <math.h>

#include <ann_ds_rnd.h>

  //                   //
 // class ANN::DS_rnd //
//                   //

static void
randomize_arr(size_t *arr, size_t len)
{
  size_t pos, tmp;
  while (len>1)
  {
    pos=floor((rand()/(RAND_MAX+1.0))*len);
    if (pos!=--len)
    {
      tmp=arr[len];
      arr[len]=arr[pos];
      arr[pos]=tmp;
    }    
  }
}

ANN::DS_rnd::DS_rnd(DS &orig_, bool mk_des)
: DS_rec(orig_,mk_des), perm_len(orig_.get_len()), current(0)
{
  if (!perm_len) perm_len=1;
  perm=new size_t[perm_len];
  for (size_t i=0; i<perm_len; ++i) perm[i]=i;
}

ANN::DS_rnd::~DS_rnd()
{
  if (perm) delete [] perm;
}

bool
ANN::DS_rnd::do_reset()
{
  if (!orig->reset()) return false;
  randomize_arr(perm,perm_len);
  return orig->seek(perm[current=0]);
}

void
ANN::DS_rnd::do_next()
{
  if (!(++current<perm_len ? orig->seek(perm[current]) : reset()))
    orig->next();
}

bool
ANN::DS_rnd::do_seek(size_t term_pos_)
{
  return orig->seek((current=term_pos_)<perm_len ? perm[term_pos_]
                                                 : term_pos_);
}

