/***************************************************************************
                          ann_ds_rec.cpp  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <ann_ds_rec.h>

  //                   //
 // class ANN::DS_rec //
//                   //

ANN::DS_rec::DS_rec(DS &orig_, bool mk_des)
: orig(&orig_)
{
  if (mk_des)
  {
    DS *des=orig->des_output();
    if (des) des_out=new DS_rec_des(*this,*des);
  }
}

ANN::DS_rec::~DS_rec()
{
}

bool
ANN::DS_rec::do_reset()
{
  return orig->reset();
}

void
ANN::DS_rec::do_next()
{
  orig->next();
}

bool
ANN::DS_rec::do_seek(size_t term_pos_)
{
  return orig->seek(term_pos_);
}

size_t
ANN::DS_rec::get_len() const
{
  return orig->get_len();
}

const ANN::Size &
ANN::DS_rec::get_sizes() const
{
  return orig->get_sizes();
}

size_t
ANN::DS_rec::get_size() const
{
  return orig->get_size();
}

ANN::Term &
ANN::DS_rec::term()
{
  return orig->term();
}

const ANN::Term &
ANN::DS_rec::term() const
{
  return orig->term();
}

size_t
ANN::DS_rec::where() const
{
  return orig->where();
}

  //                       //
 // class ANN::DS_rec_des //
//                       //

ANN::DS_rec_des::~DS_rec_des()
{
}

bool
ANN::DS_rec_des::do_reset()
{
  return false;
}

void
ANN::DS_rec_des::do_next()
{
}

bool
ANN::DS_rec_des::do_seek(size_t term_pos_)
{
  return false;
}

size_t
ANN::DS_rec_des::get_len() const
{
  return orig->get_len();
}

size_t
ANN::DS_rec_des::where() const
{
  return orig->where();
}
