/***************************************************************************
                          ann_to.h  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_TO_H
#define __ANN_TO_H

#include <ctype.h>

#include <ann_log.h>

namespace ANN
{
  class TO;
  
  inline int trained_state(int state, int upd)
  { return !state || (upd<0) ? upd : state; }
  inline int trained_state(int state, bool upd)
  { return upd ? ( state ? state : 1 ) : -1; }
  
}

#include <ann_ds.h>
#include <ann_ne.h>
#include <ann_weight.h>

namespace ANN
{

  //          //
 // class TO //
//          //

  class TO
  {
  private:
    TO(const TO &that);

  protected:
    WS     *ws;
    Log    *log;
    DS     *ds;
    NE     *elem;
    size_t  epoch, step;

    TO(Log *log_=0, WS *ws_=0);
    TO(NE &elem_, Log *log_=0, WS *ws_=0);
    TO(DS &ds_, NE &elem_, Log *log_=0, WS *ws_=0);

    virtual bool matching(const DS &ds_, const NE &elem_) const;

  public:
    TO(DS &ds_, Log *log_=0, WS *ws_=0);
    virtual ~TO();

    size_t          get_epoch() const { return epoch; }
    size_t          get_step() const { return step; }
    Log            *get_log() const { return log; }
    DS             *get_ds() const { return ds; }
    virtual bool    act_on(DS &ds_);
    virtual bool    act_on(NE &elem_);
    virtual void    reset(bool b_reload=false);
    virtual void    randomize();
    void            register_weight(W &w);
    virtual bool    load(Parser_log &parser, time_t begin=0,
                         time_t end=NAV_get(time_t));  
    virtual void    store(Log &log_); 
    virtual size_t  train(size_t epochs=1)=0;
  };

} //namespace ANN

#endif /* __ANN_TO_H */
