/***************************************************************************
                          ann_time.h  -  description
                             -------------------
    begin                : pi kwi 18 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_TIME_H
#define __ANN_TIME_H

#include <time.h>
#include <ann_nav.h>

namespace ANN
{

  class Time;
  class Time_unix;
  
  class NAV<time_t>
  {
  public:
    static time_t get() { return time_t(-1); }
  };

  //            //
 // class Time //
//            //

  class Time
  {
  public:
    class Buffer
    {
    protected:  
      size_t  length;
      char   *buffer;
    public:  
      Buffer(size_t len=0)
      : length(len), buffer(len ? new char[len+1] : 0) {}
      Buffer(const Buffer &that)
      : length(that.length),
        buffer(that.length ? new char[that.length+1] : 0) {}
      ~Buffer() { if (buffer) delete [] buffer; }
      char *c_str() { return buffer; }
      const char *c_str() const { return buffer; }
      void resize(size_t len)
      {
        if (len>length)
        {
          if (buffer) delete [] buffer;
          buffer=new char[(length=len)+1];
        }
      }
      Buffer &operator = (const Buffer &that);
    };
    
    static Time format;
    
    Time() {}
    virtual ~Time();

    virtual size_t stamp(Buffer &buff);
    virtual time_t parse(const Buffer &buff);
  };

  //                 //
 // class Time_unix //
//                 //

  class Time_unix : public Time
  {
  public:
    static Time_unix format;

    Time_unix() {}
    virtual ~Time_unix();

    virtual size_t stamp(Buffer &buff);
    virtual time_t parse(const Buffer &buff);
  };

} // namespace ANN

#endif /* __ANN_TIME_H */
