/***************************************************************************
                          ann_loc.h  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_LOC_H
#define __ANN_LOC_H

#include <ctype.h>

/* for debug */
#include <iostream>

namespace ANN
{

  class Loc;  /* position pointer to multidimensional arrays */
  class Size; /* Size of multidimensional arrays */

  const size_t size_max=size_t(-1);

  //           //
 // class Loc //
//           //

  class Loc
  {
  protected:
    static size_t  nav;
    size_t         dimension;
    size_t        *coordinates;

    static size_t get_dim(const size_t *coordinates_);
    
  public:
    void        resize(size_t dimension_, const size_t *coordinates_=0);
    void        resize(const size_t *coordinates_)
    { resize(get_dim(coordinates_),coordinates_); }
    void        resize(const Loc &that)
    { resize(that.dimension,that.coordinates); }
    inline void resize(const Size &that);

    Loc() : dimension(0), coordinates(0) {}
    Loc(const Loc &that) 
    : dimension(0), coordinates(0) { resize(that); }
    Loc(const Size &that) 
    : dimension(0), coordinates(0) { resize(that); }
    Loc(size_t dimension_, const size_t *coordinates_=0)
    : dimension(0), coordinates(0) { resize(dimension_,coordinates_); }
    Loc(const size_t *coordinates_)
    : dimension(0), coordinates(0) { resize(coordinates_); }

    ~Loc();

    size_t  dim() const { return dimension; }
    size_t *coord() const { return coordinates; }
    size_t  product() const; /* multiplication of all coordinates */
    Loc    &expand(const Loc &that);
    /* expands each coords, so each of them is max of its previous value and
     * value of that */
    void    clear();
    size_t &at(size_t which_dim)
    { return which_dim<dimension ? coordinates[which_dim] : nav=size_max; }
    size_t  at(size_t which_dim) const
    { return which_dim<dimension ? coordinates[which_dim] : size_max; }
    virtual std::ostream &print(std::ostream &os) const
    { os<<'<'<<dimension<<'['; for (size_t i=0; i<dimension; ++i)
      { if (i) os<<','; os<<coordinates[i]; } return os<<"]>"; }

    size_t &operator [] (size_t which_dim) { return at(which_dim); }
    size_t  operator [] (size_t which_dim) const { return at(which_dim); }
    Loc    &operator = (const Loc &that) { resize(that); return *this; }
  };

  //            //
 // class Size //
//            //

  class Size : private Loc
  {
  protected:
    size_t total;
    
  public:
    void resize(size_t dimension_, const size_t *coordinates_=0);
    void resize(const size_t *coordinates_) 
    { resize(get_dim(coordinates_),coordinates_); }
    void resize(const Loc &that) { resize(that.dim(),that.coord()); }
    void resize(const Size &that)
    { ANN::Loc::resize(that.dimension,that.coordinates); total=that.total; }
          
    Size() : total(0) {}
    Size(const Loc &that) : total(0) { resize(that); }
    Size(const Size &that) : Loc(), total(0) { resize(that); }
    Size(size_t dimension_, const size_t *coordinates_=0)
    : total(0) { resize(dimension_,coordinates_); }
    Size(const size_t *coordinates_) : total(0) { resize(coordinates_); }

    ~Size() {}

    size_t        dim() const { return dimension; }
    const size_t *coord() const { return coordinates; }
    size_t        total_size() const { return total; }
    Size         &expand(const Loc &that);
    Size         &expand(const Size &that);
    size_t        index(const Loc &loc) const;
    /* flat index of loc using *this as limits */
    void          reset();
    size_t        at(size_t which_dim) const
    { return which_dim<dimension ? coordinates[which_dim] : size_max; }
    void          set(size_t which_dim, size_t size_);
    virtual std::ostream &print(std::ostream &os) const
    { os<<'<'<<dimension<<'['; for (size_t i=0; i<dimension; ++i) 
      { if (i) os<<','; os<<coordinates[i]; } return os<<']'<<total<<'>'; }
   
    size_t  operator [] (size_t which_dim) const { return at(which_dim); }
    size_t  operator [] (const Loc &loc) const { return index(loc); }
    Size   &operator = (const Loc &that) { resize(that); return *this; }
    Size   &operator = (const Size &that) { resize(that); return *this; }
  };

} // namespace ANN

inline void 
ANN::Loc::resize(const Size &that)
{ 
  resize(that.dim(),that.coord()); 
}

inline std::ostream &operator << (std::ostream &os, const ANN::Loc &l) { return l.print(os); }
inline std::ostream &operator << (std::ostream &os, const ANN::Loc *l) { return l->print(os); }
inline std::ostream &operator << (std::ostream &os, const ANN::Size &s) { return s.print(os); }
inline std::ostream &operator << (std::ostream &os, const ANN::Size *s) { return s->print(os); }

#endif /* __ANN_LOC_H */
