/***************************************************************************
                          ann_array.h  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_ARRAY_H
#define __ANN_ARRAY_H

#include <ctype.h>
#include <math.h>

#include <ann_nav.h>
#include <ann_loc.h>

namespace ANN
{

  template<class Elem>
  class Array;

  class NAV<double>
  {
  public:
    static double get() { return NAN; }
  };

  //template<class Elem>//
 // class Array        //
//                    //

  template<class Elem>
  class Array
  {
  public:
    typedef Elem Elem_t;
    
  private:
    Size           size;
    Elem          *data;
    static Elem    nav;

  public:
    bool resize(const Loc &limits);
    bool resize(const Size &limits);
    bool resize(size_t dimension_, const size_t *coordinates_=0)
    { return resize(Loc(dimension_,coordinates_)); }
    bool resize(const size_t *coordinates_)
    { return resize(Loc(coordinates_)); }
    void fetch(size_t size_, const Elem_t *data_);
    void fetch(const Elem_t *data_);

    Array() : data(0) {}
    Array(const Loc &loc) : data(0) { resize(loc); }
    Array(const Size &size_) : data(0) { resize(size_); }
    Array(size_t dimension_, const size_t *coordinates_=0) : data(0)
    { resize(dimension_,coordinates_); }
    Array(const size_t *coordinates_) : data(0) { resize(coordinates_); }
    Array(const Array &that) : data(0)
    { resize(that.size); fetch(that.data); }
    Array(size_t size_, const Elem_t *data_=0)
    : size(1,&size_), data(size_ ? new Elem_t[size_] : 0)
    { fetch(data_ ? size_ : 0, data_); }

    virtual ~Array();

    const Size   &get_sizes() const { return size; }
    size_t        get_size() const { return size.total_size(); }
    Elem_t       &at(size_t idx)
    { return idx<size.total_size() ? data[idx] : NAV_set(nav); }
    Elem_t        at(size_t idx) const
    { return idx<size.total_size() ? data[idx] : NAV_get(Elem); }
    Elem_t       &at(const Loc &loc) { return at(size.index(loc)); }
    Elem_t        at(const Loc &loc) const { return at(size.index(loc)); }
    Elem_t       *get_data() { return data; }
    const Elem_t *get_data() const { return data; }

    Elem_t &operator [] (size_t idx) { return at(idx); }
    Elem_t  operator [] (size_t idx) const { return at(idx); }
    Elem_t &operator [] (const Loc &loc) { return at(loc); }
    Elem_t  operator [] (const Loc &loc) const { return at(loc); }
    Array  &operator = (const Array &arr)
    { resize(arr.size); fetch(arr.data); return *this; }
  };

} // namespace ANN

template<class Elem>
Elem ANN::Array<Elem>::nav;

template<class Elem>
ANN::Array<Elem>::~Array()
{
  if (data) delete [] data;
}

template<class Elem>
bool
ANN::Array<Elem>::resize(const Loc &limits)
{
  size_t size_=(limits.dim() ? limits.product() : 0);
  if (size_==size.total_size()) return true;
  if (data) delete [] data;
  data=((size_) ? new Elem[size_] : 0);
  size=limits;
  return false;
}

template<class Elem>
bool
ANN::Array<Elem>::resize(const Size &limits)
{
  size_t size_=limits.total_size();
  if (size_==size.total_size()) return true;
  if (data) delete [] data;
  data=((size_) ? new Elem[size_] : 0);
  size=limits;
  return false;
}

template<class Elem>
void
ANN::Array<Elem>::fetch(size_t size_, const Elem *data_)
{
  size_t i;
  if (size_>size.total_size()) size_=size.total_size();
  for (i=0; i<size_; ++i) data[i]=data_[i];
  for (i=size_; i<size.total_size(); ++i) NAV_set(data[i]);
}

template<class Elem>
void
ANN::Array<Elem>::fetch(const Elem *data_)
{
  size_t i;
  for (i=0; i<size.total_size(); ++i) data[i]=data_[i];
}

#endif /* __ANN_ARRAY_H */
