/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : pon kwi 14 18:06:02 CEST 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
#include <stdlib.h>

#include <ann_cybenko.h>
#include <ann_w_step.h>
#include <ann_w_mntm.h>
#include <ann_log_io.h>
#include <ann_term.h>
#include <ann_ds_ws.h>
#include <ann_ds_tee.h>
#include <ann_ds_rnd.h>
#include <ann_ne_bprop.h>
#include <ann_ds_out.h>
#include <ann_to_offline.h>
#include <ann_to_online.h>
#include <ann_log_lazy.h>
#include <fstream>

void
sample_Cybenko(ANN::Log &log)
{
  size_t        i;
  ANN::Log_lazy lazy2(log,20);
  ANN::Log_lazy lazy3(log,30);
  ANN::Log_lazy lazy5(log,50);
  std::ifstream fdata("/home/bartek/src/ann-0.2/test.txt");
  ANN::DS_ws ds_ws(fdata);
  for (i=0; i<ds_ws.get_len(); ++i)
  {
    log.log(ds_ws.term(),"input  pattern");
    if (ds_ws.des_output()) log.log(ds_ws.des_output()->term(),"output pattern");
    ds_ws.next();
  }
  ANN::WGC_step   gr_wg_cmn(lazy5,1);
  ANN::WG_step_F  gr_wg_f(gr_wg_cmn);
  ANN::WC_step    gr_w_cmn(gr_wg_f);
  ANN::W_step_F   gr_w_f(gr_w_cmn);
  ANN::NE_bprop   sample(*ANN::create_Cybenko(&lazy3,"net_of_cybenko",4,2,4,gr_w_f,false),
                         .01,&lazy2);
  ANN::TO_offline trainer(ds_ws,&lazy5);
  trainer.act_on(sample);
  trainer.randomize();
  trainer.train(1000);
  ANN::DS_out ds_out(ds_ws,sample);
  ANN::DS_tee ds_tee(ds_out,log,"result");
  ds_tee.reset();
  for (i=1; i<ds_tee.get_len(); ++i) ds_tee.next();
}

void
sample_codec424(ANN::Log &log)
{
  size_t        i;
  ANN::Log_lazy lazy2(log,20);
  ANN::Log_lazy lazy3(log,30);
  ANN::Log_lazy lazy5(log,50);
  std::ifstream fdata("/home/bartek/src/ann-0.2/test.txt");
  ANN::DS_ws ds_ws(fdata);
  for (i=0; i<ds_ws.get_len(); ++i)
  {
    log.log(ds_ws.term(),"input  pattern");
    if (ds_ws.des_output()) log.log(ds_ws.des_output()->term(),"output pattern");
    ds_ws.next();
  }
  ANN::WGC_step   gr_wg_cmn(lazy5,10);
  ANN::WG_step_F  gr_wg_f(gr_wg_cmn);
  ANN::WC_step    gr_w_cmn(gr_wg_f);
  ANN::W_step_F   gr_w_f(gr_w_cmn);
  size_t          s;
  ANN::Size       in_size(1,&(s=4));
  ANN::Init       inst(in_size,"codec424_net");
  ANN::NEC_perc   hid_par(&lazy3,&gr_w_f,&ANN::Act::sigmoidal,true,1,&(s=2));
  ANN::NEC_perc   out_par(&lazy3,&gr_w_f,&ANN::Act::sigmoidal,true,1,&(s=4));
  ANN::NE_perc_F *factory[]=
  {
    new ANN::NE_perc_F(hid_par),
    new ANN::NE_perc_F(out_par),
  };
  ANN::NE_bprop   sample(*new ANN::NE_mlayer(&inst,log,factory,factory+2),
                         .01,&lazy2);
  ANN::NE_mlayer::drop_f(factory,factory+2);
  ANN::TO_offline trainer(ds_ws,&lazy5);
  trainer.act_on(sample);
  trainer.randomize();
  trainer.train(1000);
  ANN::DS_out ds_out(ds_ws,sample);
  ANN::DS_tee ds_tee(ds_out,log,"result");
  ds_tee.reset();
  for (i=1; i<ds_tee.get_len(); ++i) ds_tee.next();
}

void
sample_codec424_mntm_rnd(ANN::Log &log)
{
  size_t        i;
  ANN::Log_lazy lazy2(log,20);
  ANN::Log_lazy lazy3(log,30);
  ANN::Log_lazy lazy5(log,50);
  std::ifstream fdata("/home/bartek/src/ann-0.2/test.txt");
  ANN::DS_ws ds_ws(fdata);
  for (i=0; i<ds_ws.get_len(); ++i)
  {
    log.log(ds_ws.term(),"input  pattern");
    if (ds_ws.des_output()) log.log(ds_ws.des_output()->term(),"output pattern");
    ds_ws.next();
  }
  ANN::WGC_mntm   gr_wg_cmn(lazy5,.3,.9);
  ANN::WG_mntm_F  gr_wg_f(gr_wg_cmn);
  ANN::WC_mntm    gr_w_cmn(gr_wg_f);
  ANN::W_mntm_F   gr_w_f(gr_w_cmn);
  size_t          s;
  ANN::Size       in_size(1,&(s=4));
  ANN::Init       inst(in_size,"codec424_net");
  ANN::NEC_perc   hid_par(&lazy3,&gr_w_f,&ANN::Act::sigmoidal,true,1,&(s=2));
  ANN::NEC_perc   out_par(&lazy3,&gr_w_f,&ANN::Act::sigmoidal,true,1,&(s=4));
  ANN::NE_perc_F *factory[]=
  {
    new ANN::NE_perc_F(hid_par),
    new ANN::NE_perc_F(out_par),
  };
  ANN::NE_bprop   sample(*new ANN::NE_mlayer(&inst,log,factory,factory+2),
                         .01,&lazy2);
  ANN::NE_mlayer::drop_f(factory,factory+2);
  ANN::DS_rnd     ds_rnd(ds_ws);
  ANN::TO_online  trainer(ds_rnd,&lazy5);
  trainer.act_on(sample);
  trainer.randomize();
  trainer.train(1000);
  ANN::DS_out ds_out(ds_ws,sample);
  ANN::DS_tee ds_tee(ds_out,log,"result");
  ds_tee.reset();
  for (i=1; i<ds_tee.get_len(); ++i) ds_tee.next();
}

int
main(int argc, char *argv[])
{
  ANN::Log_io log(std::cout);
  sample_codec424_mntm_rnd(log);
  log.nl("the end");
  return EXIT_SUCCESS;  
}
