/***************************************************************************
                          ann_ws_set.cpp  -  description
                             -------------------
    begin                : czw kwi 17 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <ann_ws_set.h>

  //                   //
 // class ANN::WS_set //
//                   //

ANN::WS_set::~WS_set()
{
}

void
ANN::WS_set::register_weight(W &w)
{
  g_set.insert(w.get_group());
  w_set.insert(&w);
}

void
ANN::WS_set::erase_weights()
{
  g_set.clear();
  w_set.clear();
}

void
ANN::WS_set::reset(TO &t)
{
  WGs_it git, gend;
  for (git=g_set.begin(), gend=g_set.end(); git!=gend; ++git)
    (*git)->reset(t);
  Ws_it wit, wend;
  for (wit=w_set.begin(), wend=w_set.end(); wit!=wend; ++wit)
    (*wit)->reset(t);
}

void
ANN::WS_set::prepare(TO &t)
{
  WGs_it git, gend;
  for (git=g_set.begin(), gend=g_set.end(); git!=gend; ++git)
    (*git)->prepare(t);
  Ws_it wit, wend;
  for (wit=w_set.begin(), wend=w_set.end(); wit!=wend; ++wit)
    (*wit)->prepare(t);
  for (git=g_set.begin(), gend=g_set.end(); git!=gend; ++git)
    (*git)->prepared(t);
}

void
ANN::WS_set::update(TO &t)
{
  WGs_it git, gend;
  for (git=g_set.begin(), gend=g_set.end(); git!=gend; ++git)
    (*git)->update(t);
  Ws_it wit, wend;
  for (wit=w_set.begin(), wend=w_set.end(); wit!=wend; ++wit)
    (*wit)->update(t);
  for (git=g_set.begin(), gend=g_set.end(); git!=gend; ++git)
    (*git)->updated(t);
}

void
ANN::WS_set::finish(TO &t)
{
  WGs_it git, gend;
  for (git=g_set.begin(), gend=g_set.end(); git!=gend; ++git)
    (*git)->finish(t);
  Ws_it wit, wend;
  for (wit=w_set.begin(), wend=w_set.end(); wit!=wend; ++wit)
    (*wit)->finish(t);
  for (git=g_set.begin(), gend=g_set.end(); git!=gend; ++git)
    (*git)->finished(t);
}

void
ANN::WS_set::randomize()
{
  Ws_it wit, wend;
  for (wit=w_set.begin(), wend=w_set.end(); wit!=wend; ++wit)
    (*wit)->randomize();
}

bool
ANN::WS_set::load(Parser_log &parser, time_t begin, time_t end)
{
  WGs_it git, gend;
  for (git=g_set.begin(), gend=g_set.end(); git!=gend; ++git)
    if (!(*git)->load(parser,begin,end)) return false;
  Ws_it wit, wend;
  for (wit=w_set.begin(), wend=w_set.end(); wit!=wend; ++wit)
    if (!(*wit)->load(parser,begin,end)) return false;
  return true;
}

void
ANN::WS_set::store(Log &log)
{
  WGs_it git, gend;
  for (git=g_set.begin(), gend=g_set.end(); git!=gend; ++git)
    (*git)->store(log);
  Ws_it wit, wend;
  for (wit=w_set.begin(), wend=w_set.end(); wit!=wend; ++wit)
    (*wit)->store(log);
}  

