/***************************************************************************
                          ann_to_offline.cpp  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <ann_to_offline.h>

  //                       //
 // class ANN::TO_offline //
//                       //

ANN::TO_offline::~TO_offline()
{
}

size_t
ANN::TO_offline::train(size_t epochs)
{
  if (!ds || !elem) return 0;
  size_t           epoch_=0, length;
  Term             t_out(elem->get_out_sizes());
  bool             is_superv=elem->is_supervised();
  int              fin=0;
  DS              *des_out=ds->des_output();
  ds->reset();
  length=ds->get_len();
  while ((fin<1) && (epoch_<epochs))
  {
    step=0;
    if (log) log->prepare(epoch);
    elem->prepare(*this);
    ws->prepare(*this);
    for (;;)
    {
      if (log) log->stepped(step,ds->where());
      elem->calc(ds->term(), t_out);
      elem->adapt(ds->term(), t_out, is_superv ? &des_out->term() : 0, 0);
      if (length<=++step) break;
      ds->next();
    }
    if (log) log->stepped(size_max,size_max);
    ws->update(*this);
    fin=elem->update(*this);
    if (log) log->update(epoch);
    ++epoch;
    ++epoch_;
    ds->next();
  }
  if (log) log->finish(epoch);
  ws->finish(*this);
  elem->finish(*this);
  if (log) log->finished(epoch);
  return epoch_;
}
