/***************************************************************************
                          ann_to.cpp  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <ann_to.h>
#include <ann_ws_set.h>

  //               //
 // class ANN::TO //
//               //

ANN::TO::TO(Log *log_, WS *ws_)
: ws(ws_), log(log_), ds(0), elem(0)
{
  if (!ws) ws=new WS_set;
}

ANN::TO::TO(NE &elem_, Log *log_, WS *ws_)
: ws(ws_), log(log_), ds(0), elem(&elem_)
{
  if (!ws) ws=new WS_set;
  reset(true);
}

ANN::TO::TO(DS &ds_, NE &elem_, Log *log_, WS *ws_)
: ws(ws_), log(log_), ds(&ds_), elem(&elem_)
{
  if (!ws) ws=new WS_set;
  reset(true);
}

ANN::TO::TO(DS &ds_, Log *log_, WS *ws_)
: ws(ws_), log(log_), ds(&ds_), elem(0)
{
  if (!ws) ws=new WS_set;
}

ANN::TO::~TO()
{
  if (ws) delete ws;
}

bool
ANN::TO::matching(const DS &ds_, const NE &elem_) const
{
  size_t s=elem_.get_in_size();
  if (!s || (s!=ds_.input()->get_size())) return false;
  if (!elem_.is_supervised()) s=0;
  else if (!(s=elem_.get_out_size())) return false;
  const DS *out=ds_.des_output();
  if (out) return s==out->get_size();
  else return !s;
}

bool
ANN::TO::act_on(DS &ds_)
{
  if (elem && !matching(ds_,*elem)) return false;
  ds=ds_.input();
  return true;
}

bool
ANN::TO::act_on(NE &elem_)
{
  if (ds && !matching(*ds,elem_)) return false;
  elem=&elem_;
  reset(true);
  return true;
}

void
ANN::TO::reset(bool b_reload)
{
  epoch=0;
  if (b_reload) ws->erase_weights();
  if (log) log->reset();
  if (elem) elem->reset(*this,b_reload);
  ws->reset(*this);
}

void
ANN::TO::randomize()
{
  reset();
  ws->randomize();
}

void
ANN::TO::register_weight(W &w)
{
  ws->register_weight(w);
}

bool
ANN::TO::load(Parser_log &parser, time_t begin, time_t end)
{
  reset();
  return elem->load(parser,begin,end) && ws->load(parser,begin,end);
}

void
ANN::TO::store(Log &log_)
{
  elem->store(log_);
  ws->store(log_);
}

