/***************************************************************************
                          ann_tc_set.cpp  -  description
                             -------------------
    begin                : sob kwi 19 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <ann_tc_set.h>

static bool
drop_set(ANN::TC_set::TokenSet *set)
{
  ANN::TC_set::TSIterator  it;
  ANN::TC_set::Token      *ptr;
  if (!set) return false;
  while (!set->empty())
  {
    ptr=*(it=set->begin());
    set->erase(it);
    delete ptr;
  }
  delete set;
  return true;
}

  //                   //
 // class ANN::TC_set //
//                   //

bool
ANN::TC_set::TokenCmp::operator ()(const Token *t1, const Token *t2) const
{
  size_t l1=t1->loc.dim();
  size_t l2=t2->loc.dim();
  size_t i, l_=(l1<l2 ? l1 : l2);
  for (i=0; i<l_; ++i) if (t1->loc[i]!=t2->loc[i])
    return t1->loc[i]<t2->loc[i];
  return l1<l2;
}

ANN::TC_set::~TC_set()
{
  TSsIterator  i=tokens.begin();
  TSsIterator  e=tokens.end();
  while (i!=e) drop_set(*i++);
}

bool
ANN::TC_set::calc_sizes(size_t num, Size &lim_)
{
  if (num>=num_term) return false;
  lim_.resize(0,0);
  if (tokens[num_get])
  {
    TSIterator  it=tokens[num_get]->begin();
    TSIterator  end=tokens[num_get]->end();
    while (it!=end) lim_.expand((*it++)->loc);
  }
  return true;  
}

void
ANN::TC_set::reserve(size_t num)
{
  size_t i=tokens.size(), n;
  if (num>=i)
  {
    tokens.resize(num+1);
    for (n=tokens.size(); i<n; ++i) tokens[i]=0;
  }
}

void
ANN::TC_set::append(double d)
{
  if (!tokens[num_put]) tokens[num_put]=new TokenSet;
  Token *ptr=new Token(l+1,cur.coord(),d);
  tokens[num_put]->insert(ptr);
  ++cur[l];
  lim_valid=false;
}

bool
ANN::TC_set::get_next(Term &term)
{
  if (!lim_valid) recalc_size();
  bool   ret=(num_get<num_term);
  size_t i, j=0, k;
  Size   l_size(term.get_sizes());
  l_size.expand(lim);
  term.resize(l_size);
  if (ret && tokens[num_get])
  {
    Token      *ptr;
    Loc         l_it;
    TSIterator  it=tokens[num_get]->begin();
    TSIterator  end=tokens[num_get]->end();
    while (it!=end)
    {
      ptr=*it++;
      l_it=ptr->loc;
      i=l_size[l_it];
      for (k=j; k<i; ++k) term[k]=NAN;
      j=l_it.dim();
      while (j)
      {
        --j;
        if (++l_it[j]==l_size[j]) l_it[j]=0; else break;
      }
      if (!(j=l_size[l_it])) j=l_size.total_size();
      for (k=i; k<j; ++k) term[k]=ptr->d;
    }
  }
  for (k=j, i=l_size.total_size(); k<i; ++k) term[k]=NAN;
  if (ret) ++num_get;
  return ret;
}

bool
ANN::TC_set::erase(size_t num)
{
  if (num>=num_term) return false;
  if (drop_set(tokens[num]))
  {
    tokens[num]=0;
    lim_valid=false;
  }
  if (num==num_put) reset();
  return true;
}

void
ANN::TC_set::shrink()
{
  TokenSet *ts;
  while (num_term>0) if (ts=tokens[--num_term]) if (ts->empty())
  {
    delete ts;
    tokens[num_term]=0;
  }
  else
  {
    ++num_term;
    break;
  }
  if (num_put>num_term)
  {
    num_put=num_term;
    reset();
  }
  if (num_get>num_term) num_get=num_term;
  tokens.resize(num_term+(num_put==num_term));
}
