/***************************************************************************
                          ann_parser_ws.cpp  -  description
                             -------------------
    begin                : pon kwi 21 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>

#include <ann_parser_ws.h>
#include <ann_tc_set.h>
 
  //                      //
 // class ANN::Parser_ws //
//                      //

#define PARSER_WS_BUFF_LEN 1024

ANN::Parser_ws::Parser_ws()
: in(new TC_set), des_out(new TC_set), is_out(false)
{
}

ANN::Parser_ws::~Parser_ws()
{  
  if (in) delete in;
  if (des_out) delete des_out;
}

void
ANN::Parser_ws::add_val(double x)
{
  TC *target=(is_out ? des_out : in);
  if (target->level()==size_max) target->inc_level();
  target->append(x);
}

bool
ANN::Parser_ws::add_str(const char *str, size_t len)
{
  if (len==1) switch (*str)
  {
  case '-':
  case 'X':
  case 'x':
  case '*':
    add_val(NAN);
    return true;
  }
  double  d;
  int     i;
  char   *buff=new char[len+1];
  bool    ok=true;
  strncpy(buff,str,len)[len]=0;
  if (sscanf(buff,"%lg",&d)==1) add_val(d);
  else if (sscanf(buff,"%i",&i)==1) add_val(i);
  else ok=false;
  delete [] buff;
  return ok;
}

void
ANN::Parser_ws::add_line()
{
  in->put_next();
  des_out->put_next();
  while (in->length()<des_out->length())
  {
    in->inc_level();
    in->put_next();
  }
  while (des_out->length()<in->length())
  {
    des_out->inc_level();
    des_out->put_next();
  }
  is_out=false;
}

bool
ANN::Parser_ws::internal_parse(std::istream &is)
{
  char   buff[PARSER_WS_BUFF_LEN];
  size_t i, l, p=0, pos=0, len=0;
  for(;;)
  {
    if (p==len)
    {
      if ((l=p-pos) && pos) for (i=0; i<l; ++i) buff[i]=buff[pos+i];
      len=p=l;
      pos=0;
      if (!(l=PARSER_WS_BUFF_LEN-len)) return false;
      if (l=is.read(buff+len,l).gcount()) len+=l;
      else return !len || add_str(buff,len);
    }
    while (p<len) switch (buff[p])
    {
    case ' ':
    case '\t':
      if (l=p-pos) if (!add_str(buff+pos,l)) return false;
      pos=++p;
      break;
    case '|':
      if (l=p-pos) if (!add_str(buff+pos,l)) return false;
      pos=++p;
      if (is_out) return false;
      is_out=true;
      break;
    case '\r':
    case '\n':
      if (l=p-pos) if (!add_str(buff+pos,l)) return false;
      pos=++p;
      add_line();
      break;
    default:
      ++p;
    }
  }  
}

void
ANN::Parser_ws::clear(size_t pos)
{
  size_t i, l;
  for (i=pos, l=in->length(); i<l;) in->erase(--l);
  in->shrink();
  for (i=pos, l=des_out->length(); i<l;) des_out->erase(--l);
  des_out->shrink();
}

bool
ANN::Parser_ws::parse(std::istream &is)
{
  size_t last_good=in->length();
  add_line();
  bool ok=internal_parse(is);
  if (!ok) clear (last_good);
  return ok;
}
