/***************************************************************************
                          ann_ls_set.cpp  -  description
                             -------------------
    begin                : pi kwi 18 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <ann_ls_set.h>

  //                   //
 // class ANN::LS_set //
//                   //

ANN::LS_set::~LS_set()
{
  Iterator  it;
  Log_rec  *log;
  while (!children.empty())
  {
    log=*(it=children.begin());
    children.erase(it);
    delete log;
  }
}

bool
ANN::LS_set::attach(Log_rec &child)
{
  return children.insert(&child).second;
}

bool
ANN::LS_set::detach(Log_rec &child)
{
  return children.erase(&child);
}

void
ANN::LS_set::reset()
{
  Iterator it=children.begin();
  Iterator end=children.end();
  while (it!=end) prop_reset(**it++);
}

void
ANN::LS_set::prepare(size_t epoch)
{
  Iterator it=children.begin();
  Iterator end=children.end();
  while (it!=end) prop_prepare(**it++,epoch);
}

void
ANN::LS_set::stepped(size_t step_, size_t pos_)
{
  Iterator it=children.begin();
  Iterator end=children.end();
  while (it!=end) prop_stepped(**it++,step_,pos_);
}

void
ANN::LS_set::update(size_t epoch)
{
  Iterator it=children.begin();
  Iterator end=children.end();
  while (it!=end) prop_update(**it++,epoch);
}

void
ANN::LS_set::finish(size_t epoch)
{
  Iterator it=children.begin();
  Iterator end=children.end();
  while (it!=end) prop_finish(**it++,epoch);
}

void
ANN::LS_set::finished(size_t epoch)
{
  Iterator it=children.begin();
  Iterator end=children.end();
  while (it!=end) prop_finished(**it++,epoch);
}
