/***************************************************************************
                          ann_log_io.cpp  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <time.h>
#include <string.h>

#include <ann_log_io.h>

  //                   //
 // class ANN::Log_io //
//                   //

ANN::Log_io::Log_io(std::ostream &os_, const char sep_, char sub_beg_,
                    char sub_end_)
: os(&os_), marg(0), time(&Time::format), epoch(size_max), step(size_max),
  sep(sep_ ? sep_ : ' '), sub_beg(sub_beg_), sub_end(sub_end_),
  is_first(true), ch_epoch(false), ch_step(false)
{
}

ANN::Log_io::Log_io(Time &time_, std::ostream &os_, char sep_, char sub_beg_,
                    char sub_end_)
: os(&os_), marg(0), time(&time_), epoch(size_max), step(size_max),
  sep(sep_ ? sep_ : ' '), sub_beg(sub_beg_), sub_end(sub_end_),
  is_first(true), ch_epoch(false), ch_step(false)
{
}

ANN::Log_io::~Log_io()
{
  if (!is_first) *os << std::endl;
  *os << std::flush;
}

void
ANN::Log_io::write_sep()
{
  if (ch_step)
  {
    ch_step=false;
    nl(1-marg,"step starts:");
    log_uint(step);
    log_str("=>");
    log_uint(pos);
    nl(1,0);
  }
  if (ch_epoch)
  {
    ch_epoch=false;
    nl(-marg,"epoch starts:");
    log_uint(epoch);
    nl(1,0);    
  }
  if (is_first)
  {
    time->stamp(stamp);
    *os << stamp.c_str() << '\t';
    for (int i=0; i<marg; ++i) *os << sep << sep;
    is_first=false;
  }
  else *os << sep;
}

void
ANN::Log_io::new_line(int ch_marg, const char *label)
{
  if (!is_first) *os << std::endl;
  marg+=ch_marg;
  is_first=true;
  if (label) log_str(label);
}

void
ANN::Log_io::log_chr(char chr)
{
  write_sep();
  if (chr) *os << chr;
}

void
ANN::Log_io::log_str(const char *str)
{
  write_sep();
  if (str) *os << str;
}

void
ANN::Log_io::log_int(int i)
{
  write_sep();
  *os << i;
}

void
ANN::Log_io::log_uint(unsigned int u)
{
  write_sep();
  *os << u;
}

void
ANN::Log_io::log_double(double d)
{
  write_sep();
  *os << d;
}

ANN::Time &
ANN::Log_io::get_time() const
{
  return *time;
}

char
ANN::Log_io::get_separator() const
{
  return sep;
}

char
ANN::Log_io::get_sublevel_beg() const
{
  return sub_beg;
}

char
ANN::Log_io::get_sublevel_end() const
{
  return sub_end;
}

size_t
ANN::Log_io::get_margin() const
{
  return marg;
}

void
ANN::Log_io::reset(const char *label_)
{
  step=epoch=size_max;
  ch_step=ch_epoch=false;
  nl(-marg,"Reseting log");
  if (label_)
  {
    log_str("for");
    log_str(label_);
  }
  nl(0,0);
  Log::reset(label_);
}

void
ANN::Log_io::prepare(size_t epoch_)
{
  epoch=epoch_;
  step=size_max;
  ch_epoch=true;
  ch_step=false;
  Log::prepare(epoch_);
}

void
ANN::Log_io::stepped(size_t step_, size_t pos_)
{
  if (step_!=size_max)
  {
    ch_step=true;
    step=step_;
    pos=pos_;
  }  
  Log::stepped(step_,pos_);
  if (step_==size_max)   
  {
    if ((step!=size_max) && !ch_step)
    {
      nl(1-marg,"steps finished");
      nl(0,0);      
    }
    step=size_max;
    ch_step=false;
  }
}

void
ANN::Log_io::update(size_t epoch_)
{
  Log::update(epoch_);
  if ((epoch!=size_max) && !ch_epoch)
  {
    nl(-marg,"epoch finished:");
    log_uint(epoch);
    nl(0,0);
  }
  epoch=step=size_max;
  ch_step=ch_epoch=false;
}

void
ANN::Log_io::finish(size_t epoch_)
{
  epoch=step=size_max;
  ch_step=ch_epoch=false;
  nl(-marg,"training reached epoch:");
  log_uint(epoch_);
  nl(1,0);
  Log::finish(epoch_);
}

void
ANN::Log_io::finished(size_t epoch_)
{
  Log::finished(epoch_);
  epoch=step=size_max;
  ch_step=ch_epoch=false;
  nl(-marg,"training finished");
  nl(0,0);
}

ANN::Log &
ANN::Log_io::flush()
{
  os->flush();
  return *this;
}

