/***************************************************************************
                          ann_init.cpp  -  description
                             -------------------
    begin                : wto kwi 22 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <string.h>
#include <stdio.h>

#include <ann_init.h>

  //                   //
 // struct ANN::Label //
//                   //

ANN::Label::Label(const char *label_)
: buffer(0), len(0), cap(0)
{
  if (label_ && *label_)
  {
    size_t l=strlen(label_);
    resize(l+1);
    strncpy(buffer,label_,l)[len=l]=0;
  }
  else
  {
    buffer=0;
    len=cap=0;
  }
}

ANN::Label::Label(const Label &that)
: len(that.len), cap(that.cap)
{
  if (cap)
  {
    buffer=new char[cap];
    strncpy(buffer,that.buffer,len)[len]=0;
  }
  else buffer=0;
}

ANN::Label::Label(const Label *that)
: len(that->len), cap(that->cap)
{
  if (cap)
  {
    buffer=new char[cap];
    strncpy(buffer,that->buffer,len)[len]=0;
  }
  else buffer=0;
}

ANN::Label::~Label()
{
  if (buffer) delete [] buffer;
}

char *
ANN::Label::dup_label () const
{
  if (!len) return 0;
  char *str=new char[len+1];
  strncpy(str,buffer,len)[len]=0;
  return str;
}

char *
ANN::Label::dup_str (const char *str_)
{
  if (!str_) return 0;
  size_t l=strlen(str_);
  if (!l) return 0;
  char *str=new char[l+1];
  strncpy(str,str_,l)[l]=0;
  return str;
}

void
ANN::Label::resize(size_t capacity_)
{
  if (cap<capacity_)
  {
    if (cap<4) cap=4;
    while (cap<capacity_) cap*=2;
    char *tmp=new char[cap];
    if (len) strncpy(tmp,buffer,len);
    if (buffer) delete [] buffer;
    (buffer=tmp)[len]=0;
  }
}

void
ANN::Label::set_label(const char *label_, size_t pos)
{
  size_t l=strlen(label_);
  if (pos>len) pos=len;
  resize(pos+l+2);
  buffer[pos]='.';
  strcpy(buffer+ ++pos,label_);
  len=pos+l;
}

void
ANN::Label::set_index(size_t index, size_t pos)
{
  char tmp[20];
  sprintf(tmp,"[%lu]",index);
  size_t l=strlen(tmp);
  if (pos>len) pos=len;
  resize(pos+l+1);
  strcpy(buffer+pos,tmp);
  len=pos+l;
}

  //                  //
 // struct ANN::Init //
//                  //

ANN::Init::~Init()
{
}

