/***************************************************************************
                          ann_ds_tee.cpp  -  description
                             -------------------
    begin                : wto kwi 15 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <string.h>
#include <stdio.h>
 
#include <ann_ds_tee.h>
#include <ann_init.h>

  //              //
 // class DS_tee //
//              //

ANN::DS_tee::DS_tee(DS &orig_, Log &log_, const char *label_)
: DS_rec(orig_), log(&log_), label(Init::dup_str(label_))
{  
}

ANN::DS_tee::~DS_tee()
{
  if (label) delete [] label;
}

void ANN::DS_tee::log_term()
{
  size_t  w=where();
  char   *buff=new char[(label ? strlen(label) : 0)+40];
  if (label) sprintf (buff,"Input pattern %s %u", label, w);
  else sprintf (buff,"Input pattern %u", w);
  log->log(input()->term(),buff);
  if (des_output())
  {
    if (label) sprintf (buff,"Desired output %s %u", label, w);
    else sprintf (buff,"Desired output %u", w);
    log->log(des_output()->term(),buff);
  }
  delete buff;
}

bool
ANN::DS_tee::do_reset()
{
  bool ret=DS_rec::do_reset();
  if (ret) log_term();
  return ret;
}

void
ANN::DS_tee::do_next()
{
  ANN::DS_rec::do_next();
  log_term();
}

bool
ANN::DS_tee::do_seek(size_t term_pos_)
{
  bool ret=ANN::DS_rec::do_seek(term_pos_);
  if (ret) log_term();
  return ret;
}


